/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.reaction.mechanism;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.reaction.IReactionMechanism;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.reaction.mechanism.RadicalSiteRearrangementMechanismTest")
public class RadicalSiteRearrangementMechanism
implements IReactionMechanism {
    @Override
    @TestMethod(value="testInitiate_IAtomContainerSet_ArrayList_ArrayList")
    public IReaction initiate(IAtomContainerSet atomContainerSet, ArrayList<IAtom> atomList, ArrayList<IBond> bondList) throws CDKException {
        IAtomContainer reactantCloned;
        CDKAtomTypeMatcher atMatcher = CDKAtomTypeMatcher.getInstance((IChemObjectBuilder)atomContainerSet.getBuilder());
        if (atomContainerSet.getAtomContainerCount() != 1) {
            throw new CDKException("RadicalSiteRearrangementMechanism only expects one IMolecule");
        }
        if (atomList.size() != 3) {
            throw new CDKException("RadicalSiteRearrangementMechanism expects three atoms in the ArrayList");
        }
        if (bondList.size() != 1) {
            throw new CDKException("RadicalSiteRearrangementMechanism only expect one bond in the ArrayList");
        }
        IAtomContainer molecule = atomContainerSet.getAtomContainer(0);
        try {
            reactantCloned = molecule.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CDKException("Could not clone IMolecule!", (Throwable)e);
        }
        IAtom atom1 = atomList.get(0);
        IAtom atom1C = reactantCloned.getAtom(molecule.getAtomNumber(atom1));
        IAtom atom2 = atomList.get(1);
        IAtom atom2C = reactantCloned.getAtom(molecule.getAtomNumber(atom2));
        IAtom atom3 = atomList.get(2);
        IAtom atom3C = reactantCloned.getAtom(molecule.getAtomNumber(atom3));
        IBond bond1 = bondList.get(0);
        int posBond1 = molecule.getBondNumber(bond1);
        reactantCloned.removeBond(reactantCloned.getBond(posBond1));
        IBond newBond = (IBond)atom1.getBuilder().newInstance(IBond.class, new Object[]{atom1C, atom2C, IBond.Order.SINGLE});
        reactantCloned.addBond(newBond);
        List selectron = reactantCloned.getConnectedSingleElectronsList(atom2C);
        reactantCloned.removeSingleElectron((ISingleElectron)selectron.get(selectron.size() - 1));
        atom2C.setHybridization(null);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)reactantCloned);
        IAtomType type = atMatcher.findMatchingAtomType(reactantCloned, atom2C);
        if (type == null || type.getAtomTypeName().equals("X")) {
            return null;
        }
        reactantCloned.addSingleElectron((ISingleElectron)atom2C.getBuilder().newInstance(ISingleElectron.class, new Object[]{atom3C}));
        atom3C.setHybridization(null);
        AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)reactantCloned);
        type = atMatcher.findMatchingAtomType(reactantCloned, atom3C);
        if (type == null || type.getAtomTypeName().equals("X")) {
            return null;
        }
        IReaction reaction = (IReaction)atom2C.getBuilder().newInstance(IReaction.class, new Object[0]);
        reaction.addReactant(molecule);
        for (IAtom atom : molecule.atoms()) {
            IMapping mapping = (IMapping)atom2C.getBuilder().newInstance(IMapping.class, new Object[]{atom, reactantCloned.getAtom(molecule.getAtomNumber(atom))});
            reaction.addMapping(mapping);
        }
        reaction.addProduct(reactantCloned);
        return reaction;
    }
}

