/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.tools.manipulator.ChemSequenceManipulator;

@TestClass(value="org.openscience.cdk.tools.manipulator.ChemFileManipulatorTest")
public class ChemFileManipulator {
    @TestMethod(value="testGetAtomCount_IChemFile")
    public static int getAtomCount(IChemFile file) {
        int count = 0;
        for (int i = 0; i < file.getChemSequenceCount(); ++i) {
            count += ChemSequenceManipulator.getAtomCount(file.getChemSequence(i));
        }
        return count;
    }

    @TestMethod(value="testGetBondCount_IChemFile")
    public static int getBondCount(IChemFile file) {
        int count = 0;
        for (int i = 0; i < file.getChemSequenceCount(); ++i) {
            count += ChemSequenceManipulator.getBondCount(file.getChemSequence(i));
        }
        return count;
    }

    @TestMethod(value="testGetAllChemObjects_IChemFile")
    public static List<IChemObject> getAllChemObjects(IChemFile file) {
        ArrayList<IChemObject> list = new ArrayList<IChemObject>();
        for (int i = 0; i < file.getChemSequenceCount(); ++i) {
            list.add((IChemObject)file.getChemSequence(i));
            list.addAll(ChemSequenceManipulator.getAllChemObjects(file.getChemSequence(i)));
        }
        return list;
    }

    @TestMethod(value="testGetAllIDs_IChemFile")
    public static List<String> getAllIDs(IChemFile file) {
        ArrayList<String> list = new ArrayList<String>();
        if (file.getID() != null) {
            list.add(file.getID());
        }
        for (int i = 0; i < file.getChemSequenceCount(); ++i) {
            list.addAll(ChemSequenceManipulator.getAllIDs(file.getChemSequence(i)));
        }
        return list;
    }

    @TestMethod(value="testGetAllAtomContainers_IChemFile")
    public static List<IAtomContainer> getAllAtomContainers(IChemFile file) {
        ArrayList<IAtomContainer> acList = new ArrayList<IAtomContainer>();
        for (IChemSequence sequence : file.chemSequences()) {
            acList.addAll(ChemSequenceManipulator.getAllAtomContainers(sequence));
        }
        return acList;
    }

    @TestMethod(value="testGetAllChemModels_IChemFile")
    public static List<IChemModel> getAllChemModels(IChemFile file) {
        ArrayList<IChemModel> modelsList = new ArrayList<IChemModel>();
        for (int f = 0; f < file.getChemSequenceCount(); ++f) {
            for (IChemModel model : file.getChemSequence(f).chemModels()) {
                modelsList.add(model);
            }
        }
        return modelsList;
    }

    @TestMethod(value="testGetAllReactions_IChemFile")
    public static List<IReaction> getAllReactions(IChemFile file) {
        ArrayList<IReaction> reactonList = new ArrayList<IReaction>();
        List<IChemModel> chemModel = ChemFileManipulator.getAllChemModels(file);
        for (int f = 0; f < chemModel.size(); ++f) {
            for (IReaction reaction : chemModel.get(f).getReactionSet().reactions()) {
                reactonList.add(reaction);
            }
        }
        return reactonList;
    }
}

