/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.HashMap;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.graph.ConnectedComponents;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;

@TestClass(value="org.openscience.cdk.graph.ConnectivityCheckerTest")
public class ConnectivityChecker {
    @TestMethod(value="testIsConnected_IAtomContainer,testPartitionIntoMolecules_IsConnected_Consistency")
    public static boolean isConnected(IAtomContainer atomContainer) {
        if (atomContainer.getAtomCount() < 2) {
            return true;
        }
        ConnectedComponents cc = new ConnectedComponents(GraphUtil.toAdjList((IAtomContainer)atomContainer));
        return cc.nComponents() == 1;
    }

    @TestMethod(value="testPartitionIntoMolecules_IAtomContainer,testPartitionIntoMoleculesKeepsAtomIDs,testPartitionIntoMolecules_IsConnected_Consistency")
    public static IAtomContainerSet partitionIntoMolecules(IAtomContainer container) {
        ConnectedComponents cc = new ConnectedComponents(GraphUtil.toAdjList((IAtomContainer)container));
        int[] components = cc.components();
        IAtomContainer[] containers = new IAtomContainer[cc.nComponents() + 1];
        HashMap<IAtom, IAtomContainer> componentsMap = new HashMap<IAtom, IAtomContainer>(2 * container.getAtomCount());
        for (int i = 1; i < containers.length; ++i) {
            containers[i] = (IAtomContainer)container.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        }
        IAtomContainerSet containerSet = (IAtomContainerSet)container.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        for (int i = 0; i < container.getAtomCount(); ++i) {
            componentsMap.put(container.getAtom(i), containers[components[i]]);
            containers[components[i]].addAtom(container.getAtom(i));
        }
        for (IBond bond : container.bonds()) {
            ((IAtomContainer)componentsMap.get(bond.getAtom(0))).addBond(bond);
        }
        for (ISingleElectron electron : container.singleElectrons()) {
            ((IAtomContainer)componentsMap.get(electron.getAtom())).addSingleElectron(electron);
        }
        for (ILonePair lonePair : container.lonePairs()) {
            ((IAtomContainer)componentsMap.get(lonePair.getAtom())).addLonePair(lonePair);
        }
        for (IStereoElement stereo : container.stereoElements()) {
            if (stereo instanceof ITetrahedralChirality) {
                IAtom a = ((ITetrahedralChirality)stereo).getChiralAtom();
                if (!componentsMap.containsKey(a)) continue;
                ((IAtomContainer)componentsMap.get(a)).addStereoElement(stereo);
                continue;
            }
            if (stereo instanceof IDoubleBondStereochemistry) {
                IBond bond = ((IDoubleBondStereochemistry)stereo).getStereoBond();
                if (!componentsMap.containsKey(bond.getAtom(0)) || !componentsMap.containsKey(bond.getAtom(1))) continue;
                ((IAtomContainer)componentsMap.get(bond.getAtom(0))).addStereoElement(stereo);
                continue;
            }
            System.err.println("New stereoelement is not currently paritioned with ConnectivityChecker:" + stereo.getClass());
        }
        for (int i = 1; i < containers.length; ++i) {
            containerSet.addAtomContainer(containers[i]);
        }
        return containerSet;
    }
}

