/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.tools.manipulator.AtomContainerSetManipulator;
import org.openscience.cdk.tools.manipulator.MoleculeSetManipulator;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;

@TestClass(value="org.openscience.cdk.tools.manipulator.ReactionSetManipulatorTest")
public class ReactionSetManipulator {
    @TestMethod(value="testGetAtomCount_IReactionSet")
    public static int getAtomCount(IReactionSet set) {
        int count = 0;
        for (IReaction iReaction : set.reactions()) {
            count += ReactionManipulator.getAtomCount(iReaction);
        }
        return count;
    }

    @TestMethod(value="testGetBondCount_IReactionSet")
    public static int getBondCount(IReactionSet set) {
        int count = 0;
        for (IReaction iReaction : set.reactions()) {
            count += ReactionManipulator.getBondCount(iReaction);
        }
        return count;
    }

    @TestMethod(value="testRemoveAtomAndConnectedElectronContainers_IReactionSet_IAtom")
    public static void removeAtomAndConnectedElectronContainers(IReactionSet set, IAtom atom) {
        for (IReaction reaction : set.reactions()) {
            ReactionManipulator.removeAtomAndConnectedElectronContainers(reaction, atom);
        }
    }

    @TestMethod(value="testRemoveElectronContainer_IReactionSet_IElectronContainer")
    public static void removeElectronContainer(IReactionSet set, IElectronContainer electrons) {
        for (IReaction reaction : set.reactions()) {
            ReactionManipulator.removeElectronContainer(reaction, electrons);
        }
    }

    @TestMethod(value="testGetAllMolecules_IReactionSet")
    public static IAtomContainerSet getAllMolecules(IReactionSet set) {
        IAtomContainerSet moleculeSet = set.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        for (IReaction reaction : set.reactions()) {
            IAtomContainerSet molecules = ReactionManipulator.getAllMolecules(reaction);
            for (IAtomContainer ac : molecules.atomContainers()) {
                boolean contain = false;
                for (IAtomContainer atomContainer : moleculeSet.atomContainers()) {
                    if (!atomContainer.equals(ac)) continue;
                    contain = true;
                    break;
                }
                if (contain) continue;
                moleculeSet.addAtomContainer(ac);
            }
        }
        return moleculeSet;
    }

    @TestMethod(value="testGetAllIDs_IReactionSet")
    public static List<String> getAllIDs(IReactionSet set) {
        ArrayList<String> IDlist = new ArrayList<String>();
        if (set.getID() != null) {
            IDlist.add(set.getID());
        }
        for (IReaction reaction : set.reactions()) {
            IDlist.addAll(ReactionManipulator.getAllIDs(reaction));
        }
        return IDlist;
    }

    @TestMethod(value="testGetAllAtomContainers_IReactionSet")
    public static List<IAtomContainer> getAllAtomContainers(IReactionSet set) {
        return MoleculeSetManipulator.getAllAtomContainers(ReactionSetManipulator.getAllMolecules(set));
    }

    @TestMethod(value="testGetRelevantReaction_IReactionSet_IAtom")
    public static IReaction getRelevantReaction(IReactionSet set, IAtom atom) {
        for (IReaction reaction : set.reactions()) {
            IAtomContainer container = ReactionManipulator.getRelevantAtomContainer(reaction, atom);
            if (container == null) continue;
            return reaction;
        }
        return null;
    }

    @TestMethod(value="testGetRelevantReaction_IReactionSet_IBond")
    public static IReaction getRelevantReaction(IReactionSet set, IBond bond) {
        for (IReaction reaction : set.reactions()) {
            IAtomContainer container = ReactionManipulator.getRelevantAtomContainer(reaction, bond);
            if (container == null) continue;
            return reaction;
        }
        return null;
    }

    @TestMethod(value="testGetRelevantReactions_IReactionSet_IMolecule")
    public static IReactionSet getRelevantReactions(IReactionSet reactSet, IAtomContainer molecule) {
        IReactionSet newReactSet = reactSet.getBuilder().newInstance(IReactionSet.class, new Object[0]);
        IReactionSet reactSetProd = ReactionSetManipulator.getRelevantReactionsAsProduct(reactSet, molecule);
        for (IReaction reaction : reactSetProd.reactions()) {
            newReactSet.addReaction(reaction);
        }
        IReactionSet reactSetReact = ReactionSetManipulator.getRelevantReactionsAsReactant(reactSet, molecule);
        for (IReaction reaction : reactSetReact.reactions()) {
            newReactSet.addReaction(reaction);
        }
        return newReactSet;
    }

    @TestMethod(value="testGetRelevantReactionsAsReactant_IReactionSet_IMolecule")
    public static IReactionSet getRelevantReactionsAsReactant(IReactionSet reactSet, IAtomContainer molecule) {
        IReactionSet newReactSet = reactSet.getBuilder().newInstance(IReactionSet.class, new Object[0]);
        for (IReaction reaction : reactSet.reactions()) {
            for (IAtomContainer atomContainer : reaction.getReactants().atomContainers()) {
                if (!atomContainer.equals(molecule)) continue;
                newReactSet.addReaction(reaction);
            }
        }
        return newReactSet;
    }

    @TestMethod(value="testGetRelevantReactionsAsProduct_IReactionSet_IMolecule")
    public static IReactionSet getRelevantReactionsAsProduct(IReactionSet reactSet, IAtomContainer molecule) {
        IReactionSet newReactSet = reactSet.getBuilder().newInstance(IReactionSet.class, new Object[0]);
        for (IReaction reaction : reactSet.reactions()) {
            for (IAtomContainer atomContainer : reaction.getProducts().atomContainers()) {
                if (!atomContainer.equals(molecule)) continue;
                newReactSet.addReaction(reaction);
            }
        }
        return newReactSet;
    }

    @TestMethod(value="testGetRelevantAtomContainer_IReactionSet_IAtom")
    public static IAtomContainer getRelevantAtomContainer(IReactionSet set, IAtom atom) {
        for (IReaction reaction : set.reactions()) {
            IAtomContainer container = ReactionManipulator.getRelevantAtomContainer(reaction, atom);
            if (container == null) continue;
            return container;
        }
        return null;
    }

    @TestMethod(value="testGetRelevantAtomContainer_IReactionSet_IBond")
    public static IAtomContainer getRelevantAtomContainer(IReactionSet set, IBond bond) {
        for (IReaction reaction : set.reactions()) {
            IAtomContainer container = ReactionManipulator.getRelevantAtomContainer(reaction, bond);
            if (container == null) continue;
            return container;
        }
        return null;
    }

    @TestMethod(value="testSetAtomProperties_IReactionSet_Object_Object")
    public static void setAtomProperties(IReactionSet set, Object propKey, Object propVal) {
        for (IReaction reaction : set.reactions()) {
            ReactionManipulator.setAtomProperties(reaction, propKey, propVal);
        }
    }

    @TestMethod(value="testGetAllChemObjects_IReactionSet")
    public static List<IChemObject> getAllChemObjects(IReactionSet set) {
        ArrayList<IChemObject> list = new ArrayList<IChemObject>();
        list.add(set);
        for (IReaction reaction : set.reactions()) {
            list.addAll(ReactionManipulator.getAllChemObjects(reaction));
        }
        return list;
    }

    @TestMethod(value="testGetReactionByAtomContainerID_IReactionSet_String")
    public static IReaction getReactionByAtomContainerID(IReactionSet reactionSet, String id) {
        for (IReaction reaction : reactionSet.reactions()) {
            if (!AtomContainerSetManipulator.containsByID(reaction.getProducts(), id)) continue;
            return reaction;
        }
        for (IReaction reaction : reactionSet.reactions()) {
            if (!AtomContainerSetManipulator.containsByID(reaction.getReactants(), id)) continue;
            return reaction;
        }
        return null;
    }

    @TestMethod(value="testGetReactionByReactionID_IReactionSet_String")
    public static IReaction getReactionByReactionID(IReactionSet reactionSet, String id) {
        Iterable<IReaction> reactionIter = reactionSet.reactions();
        for (IReaction reaction : reactionIter) {
            if (reaction.getID() == null || !reaction.getID().equals(id)) continue;
            return reaction;
        }
        return null;
    }
}

