/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.io.IOException;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.matrix.TopologicalMatrix;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.AutocorrelationDescriptorMassTest")
public class AutocorrelationDescriptorMass
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static final String[] names = new String[]{"ATSm1", "ATSm2", "ATSm3", "ATSm4", "ATSm5"};
    private static final double CARBON_MASS = 12.010735896788;

    private static double scaledAtomicMasses(IElement element) throws IOException, ClassNotFoundException {
        Isotopes isofac = Isotopes.getInstance();
        double realmasses = isofac.getNaturalMass(element);
        return realmasses / 12.010735896788;
    }

    private static double[] listConvertion(IAtomContainer container) throws IOException, ClassNotFoundException {
        int natom = container.getAtomCount();
        double[] scalated = new double[natom];
        for (int i = 0; i < natom; ++i) {
            scalated[i] = AutocorrelationDescriptorMass.scaledAtomicMasses(container.getAtom(i));
        }
        return scalated;
    }

    @Override
    @TestMethod(value="test1")
    public DescriptorValue calculate(IAtomContainer atomContainer) {
        IAtomContainer container;
        try {
            container = atomContainer.clone();
            container = AtomContainerManipulator.removeHydrogens(container);
        }
        catch (CloneNotSupportedException e) {
            DoubleArrayResult result = new DoubleArrayResult(5);
            for (int i = 0; i < 5; ++i) {
                result.add(Double.NaN);
            }
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), result, this.getDescriptorNames(), new CDKException("Error during cloner: " + e.getMessage(), e));
        }
        try {
            double[] w = AutocorrelationDescriptorMass.listConvertion(container);
            int natom = container.getAtomCount();
            int[][] distancematrix = TopologicalMatrix.getMatrix(container);
            double[] masSum = new double[5];
            for (int k = 0; k < 5; ++k) {
                for (int i = 0; i < natom; ++i) {
                    for (int j = 0; j < natom; ++j) {
                        if (distancematrix[i][j] == k) {
                            int n = k;
                            masSum[n] = masSum[n] + w[i] * w[j];
                            continue;
                        }
                        int n = k;
                        masSum[n] = masSum[n] + 0.0;
                    }
                }
                if (k <= 0) continue;
                masSum[k] = masSum[k] / 2.0;
            }
            DoubleArrayResult result = new DoubleArrayResult(5);
            for (double aMasSum : masSum) {
                result.add(aMasSum);
            }
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), result, this.getDescriptorNames());
        }
        catch (Exception ex) {
            DoubleArrayResult result = new DoubleArrayResult(5);
            for (int i = 0; i < 5; ++i) {
                result.add(Double.NaN);
            }
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), result, this.getDescriptorNames(), new CDKException("Error while calculating the ATS_mass descriptor: " + ex.getMessage(), ex));
        }
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return new String[0];
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#autoCorrelationMass", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(5);
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
    }
}

