/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atompair;

import java.util.Iterator;
import java.util.List;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.aromaticity.Aromaticity;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.invariant.ConjugatedPiSystemsDetector;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.qsar.AbstractAtomPairDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomPairDescriptor;
import org.openscience.cdk.qsar.result.BooleanResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class PiContactDetectionDescriptor
extends AbstractAtomPairDescriptor
implements IAtomPairDescriptor {
    private static final String[] names = new String[]{"piContact"};
    private boolean checkAromaticity = false;
    IAtomContainerSet acSet = null;
    private IAtomContainer acold = null;

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#piContact", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length != 1) {
            throw new CDKException("PiContactDetectionDescriptor expects 1 parameters");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("The first parameter must be of type Boolean");
        }
        this.checkAromaticity = (Boolean)params[0];
    }

    @Override
    public Object[] getParameters() {
        Object[] params = new Object[]{this.checkAromaticity};
        return params;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new BooleanResult(false), names, e);
    }

    @Override
    public DescriptorValue calculate(IAtom first, IAtom second, IAtomContainer atomContainer) {
        IAtomContainer ac;
        try {
            ac = atomContainer.clone();
        }
        catch (CloneNotSupportedException e) {
            return this.getDummyDescriptorValue(e);
        }
        IAtom clonedFirst = ac.getAtom(atomContainer.getAtomNumber(first));
        IAtom clonedSecond = ac.getAtom(atomContainer.getAtomNumber(first));
        IAtomContainer mol = ac.getBuilder().newInstance(IAtomContainer.class, ac);
        if (this.checkAromaticity) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(mol);
                Aromaticity.cdkLegacy().apply(mol);
            }
            catch (CDKException e) {
                return this.getDummyDescriptorValue(e);
            }
        }
        boolean piContact = false;
        int counter = 0;
        if (this.acold != ac) {
            this.acold = ac;
            this.acSet = ConjugatedPiSystemsDetector.detect(mol);
        }
        Iterator<IAtomContainer> detected = this.acSet.atomContainers().iterator();
        List<IAtom> neighboorsFirst = mol.getConnectedAtomsList(clonedFirst);
        List<IAtom> neighboorsSecond = mol.getConnectedAtomsList(clonedSecond);
        while (detected.hasNext()) {
            IAtomContainer detectedAC = detected.next();
            if (detectedAC.contains(clonedFirst) && detectedAC.contains(clonedSecond)) {
                ++counter;
                break;
            }
            if (!this.isANeighboorsInAnAtomContainer(neighboorsFirst, detectedAC) || !this.isANeighboorsInAnAtomContainer(neighboorsSecond, detectedAC)) continue;
            ++counter;
            break;
        }
        if (counter > 0) {
            piContact = true;
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new BooleanResult(piContact), this.getDescriptorNames());
    }

    private boolean isANeighboorsInAnAtomContainer(List<IAtom> neighs, IAtomContainer ac) {
        boolean isIn = false;
        int count = 0;
        for (IAtom neigh : neighs) {
            if (!ac.contains(neigh)) continue;
            ++count;
        }
        if (count > 0) {
            isIn = true;
        }
        return isIn;
    }

    @Override
    public String[] getParameterNames() {
        String[] params = new String[]{"checkAromaticity"};
        return params;
    }

    @Override
    public Object getParameterType(String name) {
        if (name.equals("checkAromaticity")) {
            return true;
        }
        return null;
    }
}

