/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.graph.InitialCycles;

@TestClass(value="org.openscience.cdk.graph.VertexShortCyclesTest")
final class VertexShortCycles {
    private final List<int[]> paths;

    VertexShortCycles(int[][] graph) {
        this(new InitialCycles(graph));
    }

    VertexShortCycles(InitialCycles initialCycles) {
        int[][] graph = initialCycles.graph();
        int[] sizeOf = new int[graph.length];
        this.paths = new ArrayList<int[]>(initialCycles.numberOfCycles());
        for (InitialCycles.Cycle cycle : initialCycles.cycles()) {
            int length = cycle.length();
            int[] path = cycle.path();
            boolean found = false;
            for (int v : path) {
                if (sizeOf[v] >= 1 && length > sizeOf[v]) continue;
                found = true;
                sizeOf[v] = length;
            }
            if (!found) continue;
            for (int[] p : cycle.family()) {
                this.paths.add(p);
            }
        }
    }

    @TestMethod(value="paths_bicyclo,paths_napthalene,paths_anthracene,paths_cyclophane_even")
    int[][] paths() {
        int[][] paths = new int[this.paths.size()][0];
        for (int i = 0; i < this.paths.size(); ++i) {
            paths[i] = this.paths.get(i);
        }
        return paths;
    }

    @TestMethod(value="size_bicyclo,size_napthalene,size_anthracene,size_cyclophane_even")
    int size() {
        return this.paths.size();
    }
}

