/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionScheme;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.tools.manipulator.ReactionSchemeManipulatorTest")
public class ReactionSchemeManipulator {
    @TestMethod(value="testGetAllMolecules_IReactionScheme_IMoleculeSet")
    public static IAtomContainerSet getAllAtomContainers(IReactionScheme scheme, IAtomContainerSet molSet) {
        if (scheme.getReactionSchemeCount() != 0) {
            for (IReactionScheme rm : scheme.reactionSchemes()) {
                for (IAtomContainer ac : ReactionSchemeManipulator.getAllAtomContainers(rm, molSet).atomContainers()) {
                    boolean contain = false;
                    for (IAtomContainer atomContainer : molSet.atomContainers()) {
                        if (!atomContainer.equals(ac)) continue;
                        contain = true;
                        break;
                    }
                    if (contain) continue;
                    molSet.addAtomContainer(ac);
                }
            }
        }
        for (IReaction reaction : scheme.reactions()) {
            List<IAtomContainer> newAtomContainerSet = ReactionManipulator.getAllAtomContainers(reaction);
            for (IAtomContainer ac : newAtomContainerSet) {
                boolean contain = false;
                for (IAtomContainer atomContainer : molSet.atomContainers()) {
                    if (!atomContainer.equals(ac)) continue;
                    contain = true;
                    break;
                }
                if (contain) continue;
                molSet.addAtomContainer(ac);
            }
        }
        return molSet;
    }

    @TestMethod(value="testGetAllAtomContainers_IReactionScheme")
    public static IAtomContainerSet getAllAtomContainers(IReactionScheme scheme) {
        return ReactionSchemeManipulator.getAllAtomContainers(scheme, scheme.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]));
    }

    @TestMethod(value="testGetAllIDs_IReactionScheme")
    public static List<String> getAllIDs(IReactionScheme scheme) {
        ArrayList<String> IDlist = new ArrayList<String>();
        if (scheme.getID() != null) {
            IDlist.add(scheme.getID());
        }
        for (IReaction reaction : scheme.reactions()) {
            IDlist.addAll(ReactionManipulator.getAllIDs(reaction));
        }
        if (scheme.getReactionSchemeCount() != 0) {
            for (IReactionScheme rs : scheme.reactionSchemes()) {
                IDlist.addAll(ReactionSchemeManipulator.getAllIDs(rs));
            }
        }
        return IDlist;
    }

    @TestMethod(value="testGetAllReactions_IReactionScheme")
    public static IReactionSet getAllReactions(IReactionScheme scheme) {
        IReactionSet reactionSet = scheme.getBuilder().newInstance(IReactionSet.class, new Object[0]);
        if (scheme.getReactionSchemeCount() != 0) {
            for (IReactionScheme schemeInt : scheme.reactionSchemes()) {
                for (IReaction reaction : ReactionSchemeManipulator.getAllReactions(schemeInt).reactions()) {
                    reactionSet.addReaction(reaction);
                }
            }
        }
        for (IReaction reaction : scheme.reactions()) {
            reactionSet.addReaction(reaction);
        }
        return reactionSet;
    }

    @TestMethod(value="testCreateReactionScheme_IReactionSet")
    public static IReactionScheme createReactionScheme(IReactionSet reactionSet) {
        IReactionScheme reactionScheme = reactionSet.getBuilder().newInstance(IReactionScheme.class, new Object[0]);
        ArrayList<IReaction> listTopR = new ArrayList<IReaction>();
        for (IReaction reaction : reactionSet.reactions()) {
            if (ReactionSchemeManipulator.extractPrecursorReaction(reaction, reactionSet).getReactionCount() != 0) continue;
            listTopR.add(reaction);
        }
        for (IReaction reaction : listTopR) {
            reactionScheme.addReaction(reaction);
            IReactionScheme newReactionScheme = ReactionSchemeManipulator.setScheme(reaction, reactionSet);
            if (newReactionScheme.getReactionCount() == 0 && newReactionScheme.getReactionSchemeCount() == 0) continue;
            reactionScheme.add(newReactionScheme);
        }
        return reactionScheme;
    }

    @TestMethod(value="testExtractTopReactions_IReactionScheme")
    public static IReactionSet extractTopReactions(IReactionScheme reactionScheme) {
        IReactionSet reactionSet = reactionScheme.getBuilder().newInstance(IReactionSet.class, new Object[0]);
        IReactionSet allSet = ReactionSchemeManipulator.getAllReactions(reactionScheme);
        for (IReaction reaction : allSet.reactions()) {
            IReactionSet precuSet = ReactionSchemeManipulator.extractPrecursorReaction(reaction, allSet);
            if (precuSet.getReactionCount() != 0) continue;
            boolean found = false;
            for (IReaction reactIn : reactionSet.reactions()) {
                if (!reactIn.equals(reaction)) continue;
                found = true;
            }
            if (found) continue;
            reactionSet.addReaction(reaction);
        }
        return reactionSet;
    }

    private static IReactionScheme setScheme(IReaction reaction, IReactionSet reactionSet) {
        IReactionScheme reactionScheme = reaction.getBuilder().newInstance(IReactionScheme.class, new Object[0]);
        IReactionSet reactConSet = ReactionSchemeManipulator.extractSubsequentReaction(reaction, reactionSet);
        if (reactConSet.getReactionCount() != 0) {
            for (IReaction reactionInt : reactConSet.reactions()) {
                reactionScheme.addReaction(reactionInt);
                IReactionScheme newRScheme = ReactionSchemeManipulator.setScheme(reactionInt, reactionSet);
                if (newRScheme.getReactionCount() == 0 && newRScheme.getReactionSchemeCount() == 0) continue;
                reactionScheme.add(newRScheme);
            }
        }
        return reactionScheme;
    }

    private static IReactionSet extractPrecursorReaction(IReaction reaction, IReactionSet reactionSet) {
        IReactionSet reactConSet = reaction.getBuilder().newInstance(IReactionSet.class, new Object[0]);
        for (IAtomContainer reactant : reaction.getReactants().atomContainers()) {
            for (IReaction reactionInt : reactionSet.reactions()) {
                for (IAtomContainer precursor : reactionInt.getProducts().atomContainers()) {
                    if (!reactant.equals(precursor)) continue;
                    reactConSet.addReaction(reactionInt);
                }
            }
        }
        return reactConSet;
    }

    private static IReactionSet extractSubsequentReaction(IReaction reaction, IReactionSet reactionSet) {
        IReactionSet reactConSet = reaction.getBuilder().newInstance(IReactionSet.class, new Object[0]);
        for (IAtomContainer reactant : reaction.getProducts().atomContainers()) {
            for (IReaction reactionInt : reactionSet.reactions()) {
                for (IAtomContainer precursor : reactionInt.getReactants().atomContainers()) {
                    if (!reactant.equals(precursor)) continue;
                    reactConSet.addReaction(reactionInt);
                }
            }
        }
        return reactConSet;
    }

    @TestMethod(value="testGetAtomContainerSet_IAtomContainer_IAtomContainer_IReactionScheme")
    public static ArrayList<IAtomContainerSet> getAtomContainerSet(IAtomContainer origenMol, IAtomContainer finalMol, IReactionScheme reactionScheme) {
        ArrayList<IAtomContainerSet> listPath = new ArrayList<IAtomContainerSet>();
        IReactionSet reactionSet = ReactionSchemeManipulator.getAllReactions(reactionScheme);
        boolean found = false;
        block0: for (IReaction reaction : reactionSet.reactions()) {
            if (found) break;
            for (IAtomContainer reactant : reaction.getReactants().atomContainers()) {
                if (found) continue block0;
                if (!reactant.equals(origenMol)) continue;
                IAtomContainerSet allSet = reactionSet.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                for (IAtomContainer product : reaction.getProducts().atomContainers()) {
                    if (found) continue block0;
                    if (!product.equals(finalMol)) {
                        IAtomContainerSet allSet2 = ReactionSchemeManipulator.getReactionPath(product, finalMol, reactionSet);
                        if (allSet2.getAtomContainerCount() != 0) {
                            allSet.addAtomContainer(origenMol);
                            allSet.addAtomContainer(product);
                            allSet.add(allSet2);
                        }
                    } else {
                        allSet.addAtomContainer(origenMol);
                        allSet.addAtomContainer(product);
                    }
                    if (allSet.getAtomContainerCount() == 0) continue;
                    listPath.add(allSet);
                    found = true;
                }
                continue block0;
            }
        }
        return listPath;
    }

    private static IAtomContainerSet getReactionPath(IAtomContainer reactant, IAtomContainer finalMol, IReactionSet reactionSet) {
        IAtomContainerSet allSet = reactionSet.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        for (IReaction reaction : reactionSet.reactions()) {
            for (IAtomContainer reactant2 : reaction.getReactants().atomContainers()) {
                if (!reactant2.equals(reactant)) continue;
                for (IAtomContainer product : reaction.getProducts().atomContainers()) {
                    if (!product.equals(finalMol)) {
                        IAtomContainerSet allSet2 = ReactionSchemeManipulator.getReactionPath(product, finalMol, reactionSet);
                        if (allSet2.getAtomContainerCount() == 0) continue;
                        allSet.addAtomContainer(reactant);
                        allSet.add(allSet2);
                        continue;
                    }
                    allSet.addAtomContainer(product);
                    return allSet;
                }
            }
        }
        return allSet;
    }
}

