/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.AtomContainerSetManipulator;
import org.openscience.cdk.tools.manipulator.MoleculeSetManipulator;
import org.openscience.cdk.tools.manipulator.ReactionSetManipulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.tools.manipulator.ChemModelManipulatorTest")
public class ChemModelManipulator {
    @TestMethod(value="testGetAtomCount_IChemModel")
    public static int getAtomCount(IChemModel chemModel) {
        IReactionSet reactionSet;
        IAtomContainerSet moleculeSet;
        int count = 0;
        ICrystal crystal = chemModel.getCrystal();
        if (crystal != null) {
            count += crystal.getAtomCount();
        }
        if ((moleculeSet = chemModel.getMoleculeSet()) != null) {
            count += MoleculeSetManipulator.getAtomCount(moleculeSet);
        }
        if ((reactionSet = chemModel.getReactionSet()) != null) {
            count += ReactionSetManipulator.getAtomCount(reactionSet);
        }
        return count;
    }

    @TestMethod(value="testGetBondCount_IChemModel")
    public static int getBondCount(IChemModel chemModel) {
        IReactionSet reactionSet;
        IAtomContainerSet moleculeSet;
        int count = 0;
        ICrystal crystal = chemModel.getCrystal();
        if (crystal != null) {
            count += crystal.getBondCount();
        }
        if ((moleculeSet = chemModel.getMoleculeSet()) != null) {
            count += MoleculeSetManipulator.getBondCount(moleculeSet);
        }
        if ((reactionSet = chemModel.getReactionSet()) != null) {
            count += ReactionSetManipulator.getBondCount(reactionSet);
        }
        return count;
    }

    @TestMethod(value="testRemoveAtomAndConnectedElectronContainers_IChemModel_IAtom")
    public static void removeAtomAndConnectedElectronContainers(IChemModel chemModel, IAtom atom) {
        IReactionSet reactionSet;
        ICrystal crystal = chemModel.getCrystal();
        if (crystal != null) {
            if (crystal.contains(atom)) {
                crystal.removeAtomAndConnectedElectronContainers(atom);
            }
            return;
        }
        IAtomContainerSet moleculeSet = chemModel.getMoleculeSet();
        if (moleculeSet != null) {
            MoleculeSetManipulator.removeAtomAndConnectedElectronContainers(moleculeSet, atom);
        }
        if ((reactionSet = chemModel.getReactionSet()) != null) {
            ReactionSetManipulator.removeAtomAndConnectedElectronContainers(reactionSet, atom);
        }
    }

    @TestMethod(value="testRemoveElectronContainer_IChemModel_IElectronContainer")
    public static void removeElectronContainer(IChemModel chemModel, IElectronContainer electrons) {
        IReactionSet reactionSet;
        ICrystal crystal = chemModel.getCrystal();
        if (crystal != null) {
            if (crystal.contains(electrons)) {
                crystal.removeElectronContainer(electrons);
            }
            return;
        }
        IAtomContainerSet moleculeSet = chemModel.getMoleculeSet();
        if (moleculeSet != null) {
            MoleculeSetManipulator.removeElectronContainer(moleculeSet, electrons);
        }
        if ((reactionSet = chemModel.getReactionSet()) != null) {
            ReactionSetManipulator.removeElectronContainer(reactionSet, electrons);
        }
    }

    @TestMethod(value="testCreateNewMolecule_IChemModel")
    public static IAtomContainer createNewMolecule(IChemModel chemModel) {
        IAtomContainer molecule = chemModel.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        if (chemModel.getMoleculeSet() != null) {
            IAtomContainerSet moleculeSet = chemModel.getMoleculeSet();
            for (int i = 0; i < moleculeSet.getAtomContainerCount(); ++i) {
                if (moleculeSet.getAtomContainer(i).getAtomCount() != 0) continue;
                moleculeSet.removeAtomContainer(i);
                --i;
            }
            moleculeSet.addAtomContainer(molecule);
        } else {
            IAtomContainerSet moleculeSet = chemModel.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
            moleculeSet.addAtomContainer(molecule);
            chemModel.setMoleculeSet(moleculeSet);
        }
        return molecule;
    }

    @TestMethod(value="testNewChemModel_IAtomContainer")
    public static IChemModel newChemModel(IAtomContainer atomContainer) {
        IChemModel model = atomContainer.getBuilder().newInstance(IChemModel.class, new Object[0]);
        IAtomContainerSet moleculeSet = model.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        moleculeSet.addAtomContainer(atomContainer);
        model.setMoleculeSet(moleculeSet);
        return model;
    }

    @TestMethod(value="testGetRelevantAtomContainer_IChemModel_IAtom")
    public static IAtomContainer getRelevantAtomContainer(IChemModel chemModel, IAtom atom) {
        IAtomContainerSet moleculeSet;
        IAtomContainer result = null;
        if (chemModel.getMoleculeSet() != null && (result = MoleculeSetManipulator.getRelevantAtomContainer(moleculeSet = chemModel.getMoleculeSet(), atom)) != null) {
            return result;
        }
        if (chemModel.getReactionSet() != null) {
            IReactionSet reactionSet = chemModel.getReactionSet();
            return ReactionSetManipulator.getRelevantAtomContainer(reactionSet, atom);
        }
        if (chemModel.getCrystal() != null && chemModel.getCrystal().contains(atom)) {
            return chemModel.getCrystal();
        }
        if (chemModel.getRingSet() != null) {
            return AtomContainerSetManipulator.getRelevantAtomContainer((IAtomContainerSet)chemModel.getRingSet(), atom);
        }
        throw new IllegalArgumentException("The provided atom is not part of this IChemModel.");
    }

    @TestMethod(value="testGetRelevantAtomContainer_IChemModel_IBond")
    public static IAtomContainer getRelevantAtomContainer(IChemModel chemModel, IBond bond) {
        IAtomContainerSet moleculeSet;
        IAtomContainer result = null;
        if (chemModel.getMoleculeSet() != null && (result = MoleculeSetManipulator.getRelevantAtomContainer(moleculeSet = chemModel.getMoleculeSet(), bond)) != null) {
            return result;
        }
        if (chemModel.getReactionSet() != null) {
            IReactionSet reactionSet = chemModel.getReactionSet();
            return ReactionSetManipulator.getRelevantAtomContainer(reactionSet, bond);
        }
        return null;
    }

    @TestMethod(value="testGetRelevantReaction_IChemModel_IAtom")
    public static IReaction getRelevantReaction(IChemModel chemModel, IAtom atom) {
        IReaction reaction = null;
        if (chemModel.getReactionSet() != null) {
            IReactionSet reactionSet = chemModel.getReactionSet();
            reaction = ReactionSetManipulator.getRelevantReaction(reactionSet, atom);
        }
        return reaction;
    }

    @TestMethod(value="testGetAllAtomContainers_IChemModel")
    public static List<IAtomContainer> getAllAtomContainers(IChemModel chemModel) {
        IAtomContainerSet moleculeSet = chemModel.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        if (chemModel.getMoleculeSet() != null) {
            moleculeSet.add(chemModel.getMoleculeSet());
        }
        if (chemModel.getReactionSet() != null) {
            moleculeSet.add(ReactionSetManipulator.getAllMolecules(chemModel.getReactionSet()));
        }
        return MoleculeSetManipulator.getAllAtomContainers(moleculeSet);
    }

    @TestMethod(value="testSetAtomProperties_IChemModel_Object_Object")
    public static void setAtomProperties(IChemModel chemModel, Object propKey, Object propVal) {
        if (chemModel.getMoleculeSet() != null) {
            MoleculeSetManipulator.setAtomProperties(chemModel.getMoleculeSet(), propKey, propVal);
        }
        if (chemModel.getReactionSet() != null) {
            ReactionSetManipulator.setAtomProperties(chemModel.getReactionSet(), propKey, propVal);
        }
        if (chemModel.getCrystal() != null) {
            AtomContainerManipulator.setAtomProperties(chemModel.getCrystal(), propKey, propVal);
        }
    }

    @TestMethod(value="testGetAllChemObjects_IChemModel")
    public static List<IChemObject> getAllChemObjects(IChemModel chemModel) {
        IReactionSet reactionSet;
        IAtomContainerSet moleculeSet;
        ArrayList<IChemObject> list = new ArrayList<IChemObject>();
        ICrystal crystal = chemModel.getCrystal();
        if (crystal != null) {
            list.add(crystal);
        }
        if ((moleculeSet = chemModel.getMoleculeSet()) != null) {
            list.add(moleculeSet);
            List<IChemObject> current = MoleculeSetManipulator.getAllChemObjects(moleculeSet);
            for (IChemObject chemObject : current) {
                if (list.contains(chemObject)) continue;
                list.add(chemObject);
            }
        }
        if ((reactionSet = chemModel.getReactionSet()) != null) {
            list.add(reactionSet);
            List<IChemObject> current = ReactionSetManipulator.getAllChemObjects(reactionSet);
            for (IChemObject chemObject : current) {
                if (list.contains(chemObject)) continue;
                list.add(chemObject);
            }
        }
        return list;
    }

    @TestMethod(value="testGetAllIDs_IChemModel")
    public static List<String> getAllIDs(IChemModel chemModel) {
        IReactionSet reactionSet;
        IAtomContainerSet moleculeSet;
        ICrystal crystal;
        ArrayList<String> list = new ArrayList<String>();
        if (chemModel.getID() != null) {
            list.add(chemModel.getID());
        }
        if ((crystal = chemModel.getCrystal()) != null) {
            list.addAll(AtomContainerManipulator.getAllIDs(crystal));
        }
        if ((moleculeSet = chemModel.getMoleculeSet()) != null) {
            list.addAll(MoleculeSetManipulator.getAllIDs(moleculeSet));
        }
        if ((reactionSet = chemModel.getReactionSet()) != null) {
            list.addAll(ReactionSetManipulator.getAllIDs(reactionSet));
        }
        return list;
    }
}

