/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.helper;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;

@TestClass(value="org.openscience.cdk.smsd.helper.LabelContainerTest")
public class LabelContainer {
    private List<String> labelMap = new ArrayList<String>();
    private int labelCounter = 0;
    private static LabelContainer instance = null;

    protected LabelContainer() {
        this.labelMap.add(this.labelCounter++, "X");
        this.labelMap.add(this.labelCounter++, "R");
    }

    @TestMethod(value="testGetInstance")
    public static synchronized LabelContainer getInstance() {
        if (instance == null) {
            instance = new LabelContainer();
        }
        return instance;
    }

    @TestMethod(value="testAddLabel")
    public synchronized void addLabel(String label) {
        if (!this.labelMap.contains(label)) {
            this.labelMap.add(this.labelCounter++, label);
        }
    }

    @TestMethod(value="testGetLabelID")
    public synchronized Integer getLabelID(String label) {
        this.addLabel(label);
        return this.labelMap.indexOf(label);
    }

    @TestMethod(value="testGetLabel")
    public synchronized String getLabel(Integer labelID) {
        return this.labelMap.get(labelID);
    }

    @TestMethod(value="testGetSize")
    public synchronized int getSize() {
        return this.labelMap.size();
    }
}

