/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.silent;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.silent.ChemObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomContainerSet
extends ChemObject
implements Serializable,
IAtomContainerSet,
IChemObjectListener,
Cloneable {
    private static final long serialVersionUID = -521290255592768395L;
    protected IAtomContainer[] atomContainers = new IAtomContainer[this.growArraySize];
    protected int atomContainerCount = 0;
    protected Double[] multipliers = new Double[this.growArraySize];
    protected int growArraySize = 5;

    @Override
    public void addAtomContainer(IAtomContainer atomContainer) {
        this.addAtomContainer(atomContainer, 1.0);
    }

    @Override
    public void removeAtomContainer(IAtomContainer atomContainer) {
        for (int i = this.atomContainerCount - 1; i >= 0; --i) {
            if (this.atomContainers[i] != atomContainer) continue;
            this.removeAtomContainer(i);
        }
    }

    @Override
    public void removeAllAtomContainers() {
        for (int pos = this.atomContainerCount - 1; pos >= 0; --pos) {
            this.multipliers[pos] = 0.0;
            this.atomContainers[pos] = null;
        }
        this.atomContainerCount = 0;
    }

    @Override
    public void removeAtomContainer(int pos) {
        for (int i = pos; i < this.atomContainerCount - 1; ++i) {
            this.atomContainers[i] = this.atomContainers[i + 1];
            this.multipliers[i] = this.multipliers[i + 1];
        }
        this.atomContainers[this.atomContainerCount - 1] = null;
        --this.atomContainerCount;
    }

    @Override
    public void replaceAtomContainer(int position, IAtomContainer container) {
        IAtomContainer old = this.atomContainers[position];
        this.atomContainers[position] = container;
    }

    @Override
    public boolean setMultiplier(IAtomContainer container, Double multiplier) {
        for (int i = 0; i < this.atomContainers.length; ++i) {
            if (this.atomContainers[i] != container) continue;
            this.multipliers[i] = multiplier;
            return true;
        }
        return false;
    }

    @Override
    public void setMultiplier(int position, Double multiplier) {
        this.multipliers[position] = multiplier;
    }

    @Override
    public Double[] getMultipliers() {
        Double[] returnArray = new Double[this.atomContainerCount];
        System.arraycopy(this.multipliers, 0, returnArray, 0, this.atomContainerCount);
        return returnArray;
    }

    @Override
    public boolean setMultipliers(Double[] newMultipliers) {
        if (newMultipliers.length == this.atomContainerCount) {
            if (this.multipliers == null) {
                this.multipliers = new Double[this.atomContainerCount];
            }
            System.arraycopy(newMultipliers, 0, this.multipliers, 0, this.atomContainerCount);
            return true;
        }
        return false;
    }

    @Override
    public void addAtomContainer(IAtomContainer atomContainer, double multiplier) {
        if (this.atomContainerCount + 1 >= this.atomContainers.length) {
            this.growAtomContainerArray();
        }
        this.atomContainers[this.atomContainerCount] = atomContainer;
        this.multipliers[this.atomContainerCount] = multiplier;
        ++this.atomContainerCount;
    }

    @Override
    public void add(IAtomContainerSet atomContainerSet) {
        for (IAtomContainer iter : atomContainerSet.atomContainers()) {
            this.addAtomContainer(iter);
        }
    }

    @Override
    public Iterable<IAtomContainer> atomContainers() {
        return new Iterable<IAtomContainer>(){

            @Override
            public Iterator<IAtomContainer> iterator() {
                return new AtomContainerIterator();
            }
        };
    }

    @Override
    public IAtomContainer getAtomContainer(int number) {
        return this.atomContainers[number];
    }

    @Override
    public Double getMultiplier(int number) {
        return this.multipliers[number];
    }

    @Override
    public Double getMultiplier(IAtomContainer container) {
        for (int i = 0; i < this.atomContainerCount; ++i) {
            if (!this.atomContainers[i].equals(container)) continue;
            return this.multipliers[i];
        }
        return -1.0;
    }

    protected void growAtomContainerArray() {
        this.growArraySize = this.atomContainers.length;
        IAtomContainer[] newatomContainers = new IAtomContainer[this.atomContainers.length + this.growArraySize];
        System.arraycopy(this.atomContainers, 0, newatomContainers, 0, this.atomContainers.length);
        this.atomContainers = newatomContainers;
        Double[] newMultipliers = new Double[this.multipliers.length + this.growArraySize];
        System.arraycopy(this.multipliers, 0, newMultipliers, 0, this.multipliers.length);
        this.multipliers = newMultipliers;
    }

    @Override
    public int getAtomContainerCount() {
        return this.atomContainerCount;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("AtomContainerSet(");
        buffer.append(this.hashCode());
        if (this.getAtomContainerCount() > 0) {
            buffer.append(", M=").append(this.getAtomContainerCount());
            for (int i = 0; i < this.atomContainerCount; ++i) {
                buffer.append(", ").append(this.atomContainers[i].toString());
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AtomContainerSet clone = (AtomContainerSet)super.clone();
        clone.atomContainers = new IAtomContainer[this.atomContainerCount];
        clone.atomContainerCount = 0;
        for (int i = 0; i < this.atomContainerCount; ++i) {
            clone.addAtomContainer(this.atomContainers[i].clone());
            clone.setMultiplier(i, this.getMultiplier(i));
        }
        return clone;
    }

    @Override
    public void stateChanged(IChemObjectChangeEvent event) {
    }

    @Override
    @TestMethod(value="testSortAtomContainers_Comparator_Null,testSort_Coefficients,testSort_BrokenComparator,testSort_empty")
    public void sortAtomContainers(final Comparator<IAtomContainer> comparator) {
        Integer[] indexes = new Integer[this.atomContainerCount];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = i;
        }
        Arrays.sort(indexes, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return comparator.compare(AtomContainerSet.this.atomContainers[o1], AtomContainerSet.this.atomContainers[o2]);
            }
        });
        IAtomContainer[] containersTmp = Arrays.copyOf(this.atomContainers, indexes.length);
        Double[] multipliersTmp = Arrays.copyOf(this.multipliers, indexes.length);
        for (int i = 0; i < indexes.length; ++i) {
            this.atomContainers[i] = containersTmp[indexes[i]];
            this.multipliers[i] = multipliersTmp[indexes[i]];
        }
    }

    @Override
    @TestMethod(value="testIsEmpty")
    public boolean isEmpty() {
        return this.atomContainerCount == 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AtomContainerIterator
    implements Iterator<IAtomContainer> {
        private int pointer = 0;

        private AtomContainerIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.pointer < AtomContainerSet.this.atomContainerCount;
        }

        @Override
        public IAtomContainer next() {
            return AtomContainerSet.this.atomContainers[this.pointer++];
        }

        @Override
        public void remove() {
            AtomContainerSet.this.removeAtomContainer(--this.pointer);
        }
    }
}

