/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import uk.ac.ebi.beam.CharBuffer;
import uk.ac.ebi.beam.InvalidSmilesException;

public enum Configuration {
    UNKNOWN(Type.None, ""),
    ANTI_CLOCKWISE(Type.Implicit, "@"),
    CLOCKWISE(Type.Implicit, "@@"),
    TH1(Type.Tetrahedral, "@TH1", ANTI_CLOCKWISE),
    TH2(Type.Tetrahedral, "@TH2", CLOCKWISE),
    DB1(Type.DoubleBond, "@DB1", ANTI_CLOCKWISE),
    DB2(Type.DoubleBond, "@DB2", CLOCKWISE),
    AL1(Type.ExtendedTetrahedral, "@AL1", ANTI_CLOCKWISE),
    AL2(Type.ExtendedTetrahedral, "@AL2", CLOCKWISE),
    SP1(Type.SquarePlanar, "@SP1"),
    SP2(Type.SquarePlanar, "@SP2"),
    SP3(Type.SquarePlanar, "@SP3"),
    TB1(Type.TrigonalBipyramidal, "@TB1", ANTI_CLOCKWISE),
    TB2(Type.TrigonalBipyramidal, "@TB2", CLOCKWISE),
    TB3(Type.TrigonalBipyramidal, "@TB3"),
    TB4(Type.TrigonalBipyramidal, "@TB4"),
    TB5(Type.TrigonalBipyramidal, "@TB5"),
    TB6(Type.TrigonalBipyramidal, "@TB6"),
    TB7(Type.TrigonalBipyramidal, "@TB7"),
    TB8(Type.TrigonalBipyramidal, "@TB8"),
    TB9(Type.TrigonalBipyramidal, "@TB9"),
    TB10(Type.TrigonalBipyramidal, "@TB10"),
    TB11(Type.TrigonalBipyramidal, "@TB11"),
    TB12(Type.TrigonalBipyramidal, "@TB12"),
    TB13(Type.TrigonalBipyramidal, "@TB13"),
    TB14(Type.TrigonalBipyramidal, "@TB14"),
    TB15(Type.TrigonalBipyramidal, "@TB15"),
    TB16(Type.TrigonalBipyramidal, "@TB16"),
    TB17(Type.TrigonalBipyramidal, "@TB17"),
    TB18(Type.TrigonalBipyramidal, "@TB18"),
    TB19(Type.TrigonalBipyramidal, "@TB19"),
    TB20(Type.TrigonalBipyramidal, "@TB20"),
    OH1(Type.Octahedral, "@OH1", ANTI_CLOCKWISE),
    OH2(Type.Octahedral, "@OH2", CLOCKWISE),
    OH3(Type.Octahedral, "@OH3"),
    OH4(Type.Octahedral, "@OH4"),
    OH5(Type.Octahedral, "@OH5"),
    OH6(Type.Octahedral, "@OH6"),
    OH7(Type.Octahedral, "@OH7"),
    OH8(Type.Octahedral, "@OH8"),
    OH9(Type.Octahedral, "@OH9"),
    OH10(Type.Octahedral, "@OH10"),
    OH11(Type.Octahedral, "@OH11"),
    OH12(Type.Octahedral, "@OH12"),
    OH13(Type.Octahedral, "@OH13"),
    OH14(Type.Octahedral, "@OH14"),
    OH15(Type.Octahedral, "@OH15"),
    OH16(Type.Octahedral, "@OH16"),
    OH17(Type.Octahedral, "@OH17"),
    OH18(Type.Octahedral, "@OH18"),
    OH19(Type.Octahedral, "@OH19"),
    OH20(Type.Octahedral, "@OH20"),
    OH21(Type.Octahedral, "@OH21"),
    OH22(Type.Octahedral, "@OH22"),
    OH23(Type.Octahedral, "@OH23"),
    OH24(Type.Octahedral, "@OH24"),
    OH25(Type.Octahedral, "@OH25"),
    OH26(Type.Octahedral, "@OH26"),
    OH27(Type.Octahedral, "@OH27"),
    OH28(Type.Octahedral, "@OH28"),
    OH29(Type.Octahedral, "@OH29"),
    OH30(Type.Octahedral, "@OH30");

    private final Type type;
    private final String symbol;
    private final Configuration shorthand;
    private static final Configuration[] tbs;
    private static final Configuration[] ohs;

    private Configuration(Type type, String symbol, Configuration shorthand) {
        this.type = type;
        this.symbol = symbol;
        this.shorthand = shorthand;
    }

    private Configuration(Type type, String symbol) {
        this.type = type;
        this.symbol = symbol;
        this.shorthand = this;
    }

    public Configuration shorthand() {
        return this.shorthand;
    }

    public String symbol() {
        return this.symbol;
    }

    public Type type() {
        return this.type;
    }

    static Configuration read(CharBuffer buffer) throws InvalidSmilesException {
        if (buffer.getIf('@')) {
            if (buffer.getIf('@')) {
                return CLOCKWISE;
            }
            if (buffer.getIf('T')) {
                if (buffer.getIf('H')) {
                    if (buffer.getIf('1')) {
                        return TH1;
                    }
                    if (buffer.getIf('2')) {
                        return TH2;
                    }
                    throw new InvalidSmilesException("invalid permutation designator for @TH, valid values are @TH1 or @TH2:", buffer);
                }
                if (buffer.getIf('B')) {
                    int num = buffer.getNumber();
                    if (num < 1 || num > 20) {
                        throw new InvalidSmilesException("invalid permutation designator for @TB, valid values are '@TB1, @TB2, ... @TB20:'", buffer);
                    }
                    return tbs[num];
                }
                throw new InvalidSmilesException("'@T' is not a valid chiral specification:", buffer);
            }
            if (buffer.getIf('D')) {
                if (buffer.getIf('B')) {
                    if (buffer.getIf('1')) {
                        return DB1;
                    }
                    if (buffer.getIf('2')) {
                        return DB2;
                    }
                    throw new InvalidSmilesException("invalid permutation designator for @DB, valid values are @DB1 or @DB2:", buffer);
                }
                throw new InvalidSmilesException("'@D' is not a valid chiral specification:", buffer);
            }
            if (buffer.getIf('A')) {
                if (buffer.getIf('L')) {
                    if (buffer.getIf('1')) {
                        return AL1;
                    }
                    if (buffer.getIf('2')) {
                        return AL2;
                    }
                    throw new InvalidSmilesException("invalid permutation designator for @AL, valid values are '@AL1 or @AL2':", buffer);
                }
                throw new InvalidSmilesException("'@A' is not a valid chiral specification:", buffer);
            }
            if (buffer.getIf('S')) {
                if (buffer.getIf('P')) {
                    if (buffer.getIf('1')) {
                        return SP1;
                    }
                    if (buffer.getIf('2')) {
                        return SP2;
                    }
                    if (buffer.getIf('3')) {
                        return SP3;
                    }
                    throw new InvalidSmilesException("invalid permutation designator for @SP, valid values are '@SP1, @SP2 or @SP3':", buffer);
                }
                throw new InvalidSmilesException("'@S' is not a valid chiral specification:", buffer);
            }
            if (buffer.getIf('O')) {
                if (buffer.getIf('H')) {
                    int num = buffer.getNumber();
                    if (num < 1 || num > 30) {
                        throw new InvalidSmilesException("invalid permutation designator for @OH, valud values are '@OH1, @OH2, ... @OH30':", buffer);
                    }
                    return ohs[num];
                }
                throw new InvalidSmilesException("'@O' is not a valid chiral specification:", buffer);
            }
            return ANTI_CLOCKWISE;
        }
        return UNKNOWN;
    }

    static {
        tbs = new Configuration[21];
        ohs = new Configuration[31];
        int i = 1;
        for (Configuration config : Configuration.values()) {
            if (!config.type().equals((Object)Type.TrigonalBipyramidal)) continue;
            Configuration.tbs[i++] = config;
        }
        i = 1;
        for (Configuration config : Configuration.values()) {
            if (!config.type().equals((Object)Type.Octahedral)) continue;
            Configuration.ohs[i++] = config;
        }
    }

    public static enum DoubleBond {
        UNSPECIFIED,
        TOGETHER,
        OPPOSITE;

    }

    public static enum Type {
        None,
        Implicit,
        Tetrahedral,
        DoubleBond,
        ExtendedTetrahedral,
        SquarePlanar,
        TrigonalBipyramidal,
        Octahedral;

    }
}

