/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.tools.diff.AtomDiff;
import org.openscience.cdk.tools.diff.ElectronContainerDiff;
import org.openscience.cdk.tools.diff.tree.BondOrderDifference;
import org.openscience.cdk.tools.diff.tree.ChemObjectDifference;
import org.openscience.cdk.tools.diff.tree.IDifference;
import org.openscience.cdk.tools.diff.tree.IntegerDifference;

@TestClass(value="org.openscience.cdk.tools.diff.BondDiffTest")
public class BondDiff {
    private BondDiff() {
    }

    @TestMethod(value="testMatchAgainstItself,testDiff")
    public static String diff(IChemObject first, IChemObject second) {
        IDifference diff = BondDiff.difference(first, second);
        if (diff == null) {
            return "";
        }
        return diff.toString();
    }

    @TestMethod(value="testDifference")
    public static IDifference difference(IChemObject first, IChemObject second) {
        if (!(first instanceof IBond) || !(second instanceof IBond)) {
            return null;
        }
        IBond firstB = (IBond)first;
        IBond secondB = (IBond)second;
        ChemObjectDifference totalDiff = new ChemObjectDifference("BondDiff");
        totalDiff.addChild(BondOrderDifference.construct("order", firstB.getOrder(), secondB.getOrder()));
        totalDiff.addChild(IntegerDifference.construct("atomCount", firstB.getAtomCount(), secondB.getAtomCount()));
        if (firstB.getAtomCount() == secondB.getAtomCount()) {
            for (int i = 0; i < firstB.getAtomCount(); ++i) {
                totalDiff.addChild(AtomDiff.difference(firstB.getAtom(i), secondB.getAtom(i)));
            }
        }
        totalDiff.addChild(ElectronContainerDiff.difference(first, second));
        if (totalDiff.childCount() > 0) {
            return totalDiff;
        }
        return null;
    }
}

