/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.atomic;

import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.IntegerResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.atomic.IsProtonInAromaticSystemDescriptorTest")
public class IsProtonInAromaticSystemDescriptor
implements IAtomicDescriptor {
    private static final String[] names = new String[]{"protonInArmaticSystem"};
    private boolean checkAromaticity = false;

    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#isProtonInAromaticSystem", this.getClass().getName(), "$Id: 18371b837a5582cbcf4bffd68cddaaa35d270210 $", "The Chemistry Development Kit");
    }

    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
        if (params.length > 1) {
            throw new CDKException("IsProtonInAromaticSystemDescriptor only expects two parameters");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("The second parameter must be of type Boolean");
        }
        this.checkAromaticity = (Boolean)params[0];
    }

    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        Object[] params = new Object[]{this.checkAromaticity};
        return params;
    }

    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtom atom, IAtomContainer atomContainer) {
        IAtomContainer clonedAtomContainer;
        try {
            clonedAtomContainer = (IAtomContainer)atomContainer.clone();
        }
        catch (CloneNotSupportedException e) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), names, e);
        }
        IAtom clonedAtom = clonedAtomContainer.getAtom(atomContainer.getAtomNumber(atom));
        int isProtonInAromaticSystem = 0;
        IMolecule mol = atom.getBuilder().newInstance(IMolecule.class, clonedAtomContainer);
        if (this.checkAromaticity) {
            try {
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(mol);
                CDKHueckelAromaticityDetector.detectAromaticity(mol);
            }
            catch (CDKException e) {
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), names, e);
            }
        }
        List<IAtom> neighboor = mol.getConnectedAtomsList(clonedAtom);
        IAtom neighbour0 = neighboor.get(0);
        if (atom.getSymbol().equals("H")) {
            if (neighbour0.getFlag(5)) {
                isProtonInAromaticSystem = 1;
            } else {
                List<IAtom> betaAtoms = clonedAtomContainer.getConnectedAtomsList(neighbour0);
                for (IAtom betaAtom : betaAtoms) {
                    if (betaAtom.getFlag(5)) {
                        isProtonInAromaticSystem = 2;
                        continue;
                    }
                    isProtonInAromaticSystem = 0;
                }
            }
        } else {
            isProtonInAromaticSystem = 0;
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(isProtonInAromaticSystem), names);
    }

    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        String[] params = new String[]{"checkAromaticity"};
        return params;
    }

    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return true;
    }
}

