/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IMapping;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.MDLReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MDLRXNFormat;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.io.MDLRXNReaderTest")
public class MDLRXNReader
extends DefaultChemObjectReader {
    BufferedReader input = null;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(MDLReader.class);

    public MDLRXNReader(Reader in) {
        this(in, IChemObjectReader.Mode.RELAXED);
    }

    public MDLRXNReader(Reader in, IChemObjectReader.Mode mode) {
        this.input = in instanceof BufferedReader ? (BufferedReader)in : new BufferedReader(in);
        this.mode = mode;
    }

    public MDLRXNReader(InputStream input) {
        this(input, IChemObjectReader.Mode.RELAXED);
    }

    public MDLRXNReader(InputStream input, IChemObjectReader.Mode mode) {
        this(new InputStreamReader(input), mode);
    }

    public MDLRXNReader() {
        this(new StringReader(""));
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return MDLRXNFormat.getInstance();
    }

    @Override
    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    @Override
    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class classObject) {
        Class<?>[] interfaces = classObject.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (IChemModel.class.equals(interfaces[i])) {
                return true;
            }
            if (IChemFile.class.equals(interfaces[i])) {
                return true;
            }
            if (IReaction.class.equals(interfaces[i])) {
                return true;
            }
            if (!IReactionSet.class.equals(interfaces[i])) continue;
            return true;
        }
        Class superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IChemFile) {
            return (T)this.readChemFile((IChemFile)object);
        }
        if (object instanceof IChemModel) {
            return (T)this.readChemModel((IChemModel)object);
        }
        if (object instanceof IReactionSet) {
            return (T)this.readReactionSet((IReactionSet)object);
        }
        if (object instanceof IReaction) {
            return (T)this.readReaction(object.getBuilder());
        }
        throw new CDKException("Only supported are Reaction, ReactionSet, ChemModel and ChemFile, and not " + object.getClass().getName() + ".");
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(IChemObject object) {
        if (object instanceof IReaction) {
            return true;
        }
        if (object instanceof IChemModel) {
            return true;
        }
        if (object instanceof IChemFile) {
            return true;
        }
        return object instanceof IReactionSet;
    }

    private IChemFile readChemFile(IChemFile chemFile) throws CDKException {
        IChemSequence chemSequence = chemFile.getBuilder().newInstance(IChemSequence.class, new Object[0]);
        IChemModel chemModel = chemFile.getBuilder().newInstance(IChemModel.class, new Object[0]);
        chemSequence.addChemModel(this.readChemModel(chemModel));
        chemFile.addChemSequence(chemSequence);
        return chemFile;
    }

    private IChemModel readChemModel(IChemModel chemModel) throws CDKException {
        IReactionSet setOfReactions = chemModel.getReactionSet();
        if (setOfReactions == null) {
            setOfReactions = chemModel.getBuilder().newInstance(IReactionSet.class, new Object[0]);
        }
        chemModel.setReactionSet(this.readReactionSet(setOfReactions));
        return chemModel;
    }

    private IReactionSet readReactionSet(IReactionSet setOfReactions) throws CDKException {
        IReaction r = this.readReaction(setOfReactions.getBuilder());
        if (r != null) {
            setOfReactions.addReaction(r);
        }
        try {
            String line;
            while ((line = this.input.readLine()) != null) {
                logger.debug("line: ", line);
                String str = new String(line);
                if (str.equals("$$$$")) {
                    r = this.readReaction(setOfReactions.getBuilder());
                    if (r == null) continue;
                    setOfReactions.addReaction(r);
                    continue;
                }
                if (r == null) continue;
                String fieldName = null;
                if (str.startsWith("> ")) {
                    int index2;
                    str.substring(2);
                    int index = str.indexOf("<");
                    if (index != -1 && (index2 = str.substring(index).indexOf(">")) != -1) {
                        fieldName = str.substring(index + 1, index + index2);
                    }
                    while ((line = this.input.readLine()) != null && line.startsWith(">")) {
                        logger.debug("data header line: ", line);
                    }
                }
                if (line == null) {
                    throw new CDKException("Expecting data line here, but found null!");
                }
                String data = line;
                while ((line = this.input.readLine()) != null && line.trim().length() > 0) {
                    if (line.equals("$$$$")) {
                        logger.error("Expecting data line here, but found end of molecule: ", line);
                        break;
                    }
                    logger.debug("data line: ", line);
                    data = data + line;
                    if (line.length() >= 80) continue;
                    data = data + System.getProperty("line.separator");
                }
                if (fieldName == null) continue;
                logger.info("fieldName, data: ", fieldName, ", ", data);
                r.setProperty(fieldName, data);
            }
        }
        catch (CDKException cdkexc) {
            throw cdkexc;
        }
        catch (Exception exception) {
            String error = "Error while parsing SDF";
            logger.error(error);
            logger.debug(exception);
            throw new CDKException(error, exception);
        }
        return setOfReactions;
    }

    private IReaction readReaction(IChemObjectBuilder builder) throws CDKException {
        MDLReader reader;
        String molFileLine;
        StringBuffer molFile;
        int i;
        logger.debug("Reading new reaction");
        int linecount = 0;
        IReaction reaction = builder.newInstance(IReaction.class, new Object[0]);
        try {
            this.input.readLine();
            this.input.readLine();
            this.input.readLine();
            this.input.readLine();
        }
        catch (IOException exception) {
            logger.debug(exception);
            throw new CDKException("Error while reading header of RXN file", exception);
        }
        int reactantCount = 0;
        int productCount = 0;
        try {
            String countsLine = this.input.readLine();
            ++linecount;
            if (countsLine == null) {
                return null;
            }
            logger.debug("Line " + linecount + ": " + countsLine);
            if (countsLine.startsWith("$$$$")) {
                logger.debug("File is empty, returning empty reaction");
                return reaction;
            }
            StringTokenizer tokenizer = new StringTokenizer(countsLine);
            reactantCount = Integer.valueOf(tokenizer.nextToken());
            logger.info("Expecting " + reactantCount + " reactants in file");
            productCount = Integer.valueOf(tokenizer.nextToken());
            logger.info("Expecting " + productCount + " products in file");
        }
        catch (Exception exception) {
            logger.debug(exception);
            throw new CDKException("Error while counts line of RXN file", exception);
        }
        try {
            for (i = 1; i <= reactantCount; ++i) {
                molFile = new StringBuffer();
                this.input.readLine();
                molFileLine = "";
                do {
                    molFileLine = this.input.readLine();
                    molFile.append(molFileLine);
                    molFile.append(System.getProperty("line.separator"));
                } while (!molFileLine.equals("M  END"));
                reader = new MDLReader(new StringReader(molFile.toString()));
                IMolecule reactant = (IMolecule)reader.read((IChemObject)builder.newInstance(IMolecule.class, new Object[0]));
                reaction.addReactant(reactant);
            }
        }
        catch (CDKException exception) {
            throw exception;
        }
        catch (Exception exception) {
            logger.debug(exception);
            throw new CDKException("Error while reading reactant", exception);
        }
        try {
            for (i = 1; i <= productCount; ++i) {
                molFile = new StringBuffer();
                this.input.readLine();
                molFileLine = "";
                do {
                    molFileLine = this.input.readLine();
                    molFile.append(molFileLine);
                    molFile.append(System.getProperty("line.separator"));
                } while (!molFileLine.equals("M  END"));
                reader = new MDLReader(new StringReader(molFile.toString()), this.mode);
                IMolecule product = (IMolecule)reader.read((IChemObject)builder.newInstance(IMolecule.class, new Object[0]));
                reaction.addProduct(product);
            }
        }
        catch (CDKException exception) {
            throw exception;
        }
        catch (Exception exception) {
            logger.debug(exception);
            throw new CDKException("Error while reading products", exception);
        }
        logger.info("Reading atom-atom mapping from file");
        IAtomContainer reactingSide = builder.newInstance(IAtomContainer.class, new Object[0]);
        Iterator<IAtomContainer> molecules = reaction.getReactants().molecules().iterator();
        while (molecules.hasNext()) {
            reactingSide.add((IMolecule)molecules.next());
        }
        IAtomContainer producedSide = builder.newInstance(IAtomContainer.class, new Object[0]);
        molecules = reaction.getProducts().molecules().iterator();
        while (molecules.hasNext()) {
            producedSide.add((IMolecule)molecules.next());
        }
        int mappingCount = 0;
        block16: for (int i2 = 0; i2 < reactingSide.getAtomCount(); ++i2) {
            for (int j = 0; j < producedSide.getAtomCount(); ++j) {
                IAtom eductAtom = reactingSide.getAtom(i2);
                IAtom productAtom = producedSide.getAtom(j);
                if (eductAtom.getProperty("cdk:AtomAtomMapping") == null || !eductAtom.getProperty("cdk:AtomAtomMapping").equals(productAtom.getProperty("cdk:AtomAtomMapping"))) continue;
                reaction.addMapping(builder.newInstance(IMapping.class, eductAtom, productAtom));
                ++mappingCount;
                continue block16;
            }
        }
        logger.info("Mapped atom pairs: " + mappingCount);
        return reaction;
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.input.close();
    }
}

