/*
 * Decompiled with CFR 0.152.
 */
package signature.simple;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.Assert;
import org.junit.Test;
import signature.simple.SimpleGraph;
import signature.simple.SimpleGraphPermutor;
import signature.simple.SimpleGraphSignature;

public class CanonicalLabellingTest {
    public int[] getLabels(SimpleGraph graph) {
        SimpleGraphSignature signature = new SimpleGraphSignature(graph);
        return signature.getCanonicalLabels();
    }

    public void permuteTest(SimpleGraph graph) {
        System.out.println(String.valueOf(Arrays.toString(this.getLabels(graph))) + " " + graph);
        SimpleGraphPermutor permutor = new SimpleGraphPermutor(graph);
        HashSet<String> relabelledStrings = new HashSet<String>();
        while (permutor.hasNext()) {
            SimpleGraph permutation = permutor.next();
            int[] labels = this.getLabels(permutation);
            SimpleGraph relabelled = new SimpleGraph(permutation, labels);
            boolean isIdentity = this.isIdentity(labels);
            System.out.println(String.valueOf(Arrays.toString(labels)) + " " + permutation + " " + relabelled + " " + isIdentity);
            relabelledStrings.add(relabelled.toString());
        }
        Assert.assertEquals((int)1, (int)relabelledStrings.size());
        Iterator values = relabelledStrings.iterator();
        int i = 0;
        while (i < relabelledStrings.size()) {
            System.out.println(String.valueOf(i) + " " + (String)values.next());
            ++i;
        }
    }

    public boolean isIdentity(int[] permutation) {
        if (permutation.length < 1) {
            return true;
        }
        int prev = permutation[0];
        int i = 1;
        while (i < permutation.length) {
            if (permutation[i] < prev) {
                return false;
            }
            prev = permutation[i];
            ++i;
        }
        return true;
    }

    @Test
    public void testSimpleGraphLabelling() {
        String graphString = "0:1,1:2";
        SimpleGraph graph = new SimpleGraph(graphString);
        SimpleGraphSignature signature = new SimpleGraphSignature(graph);
        int[] labels = signature.getCanonicalLabels();
        Assert.assertTrue((boolean)this.isIdentity(labels));
    }

    @Test
    public void fourCycleTest() {
        this.permuteTest(new SimpleGraph("0:1,0:3,1:2,2:3"));
    }

    @Test
    public void fiveCycleTest() {
        this.permuteTest(new SimpleGraph("0:1,0:4,1:2,2:3,3:4"));
    }

    @Test
    public void threeFourFusedCycle() {
        this.permuteTest(new SimpleGraph("0:1,0:2,1:2,1:3,2:4,3:4"));
    }

    @Test
    public void threeThreeFusedCycle() {
        this.permuteTest(new SimpleGraph("0:1,0:2,0:3,1:4,2:4,3:4"));
    }
}

