/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.List;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.NoSuchAtomException;
import org.openscience.cdk.graph.SpanningTree;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerResult;
import org.openscience.cdk.tools.manipulator.BondManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.RotatableBondsCountDescriptorTest")
public class RotatableBondsCountDescriptor
implements IMolecularDescriptor {
    private boolean includeTerminals = false;

    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#rotatableBondsCount", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
        if (params.length != 1) {
            throw new CDKException("RotatableBondsCount expects one parameter");
        }
        if (!(params[0] instanceof Boolean)) {
            throw new CDKException("The parameter must be of type Boolean");
        }
        this.includeTerminals = (Boolean)params[0];
    }

    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        Object[] params = new Object[]{this.includeTerminals};
        return params;
    }

    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return new String[]{this.includeTerminals ? "nRotBt" : "nRotB"};
    }

    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer ac) {
        IRingSet ringSet;
        int rotatableBondsCount = 0;
        try {
            ringSet = new SpanningTree(ac).getBasicRings();
        }
        catch (NoSuchAtomException e) {
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(0), this.getDescriptorNames(), e);
        }
        for (IBond bond : ac.bonds()) {
            if (ringSet.getRings(bond).getAtomContainerCount() <= 0) continue;
            bond.setFlag(1, true);
        }
        for (IBond bond : ac.bonds()) {
            IAtom atom0 = bond.getAtom(0);
            IAtom atom1 = bond.getAtom(1);
            if (atom0.getSymbol().equals("H") || atom1.getSymbol().equals("H") || bond.getOrder() != CDKConstants.BONDORDER_SINGLE || !BondManipulator.isLowerOrder(ac.getMaximumBondOrder(atom0), IBond.Order.TRIPLE) || !BondManipulator.isLowerOrder(ac.getMaximumBondOrder(atom1), IBond.Order.TRIPLE) || bond.getFlag(1)) continue;
            int degree0 = ac.getConnectedBondsCount(atom0) - this.getConnectedHCount(ac, atom0);
            int degree1 = ac.getConnectedBondsCount(atom1) - this.getConnectedHCount(ac, atom1);
            if (degree0 == 1 || degree1 == 1) {
                if (!this.includeTerminals) continue;
                ++rotatableBondsCount;
                continue;
            }
            ++rotatableBondsCount;
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), new IntegerResult(rotatableBondsCount), this.getDescriptorNames());
    }

    private int getConnectedHCount(IAtomContainer atomContainer, IAtom atom) {
        List<IAtom> connectedAtoms = atomContainer.getConnectedAtomsList(atom);
        int n = 0;
        for (IAtom anAtom : connectedAtoms) {
            if (!anAtom.getSymbol().equals("H")) continue;
            ++n;
        }
        return n;
    }

    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerResult(1);
    }

    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        String[] params = new String[]{"includeTerminals"};
        return params;
    }

    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return true;
    }
}

