/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.MoSSOutputFormat;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.io.MoSSOutputReaderTest")
public class MoSSOutputReader
extends DefaultChemObjectReader {
    private BufferedReader input;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(MoSSOutputReader.class);

    public MoSSOutputReader(Reader input) {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public MoSSOutputReader(InputStream input) {
        this(new InputStreamReader(input));
    }

    public MoSSOutputReader() {
        this(new StringReader(""));
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return MoSSOutputFormat.getInstance();
    }

    @Override
    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader reader) throws CDKException {
        this.input = new BufferedReader(this.input);
    }

    @Override
    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class testClass) {
        Class<?>[] interfaces = testClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (IMoleculeSet.class.equals(interfaces[i])) {
                return true;
            }
            if (!IChemFile.class.equals(interfaces[i])) continue;
            return true;
        }
        Class superClass = testClass.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof IMoleculeSet) {
            IMoleculeSet cf = (IMoleculeSet)object;
            try {
                cf = this.readMoleculeSet(cf);
            }
            catch (IOException e) {
                logger.error("Input/Output error while reading from input.");
            }
            return (T)cf;
        }
        if (object instanceof IChemFile) {
            IChemFile chemFile = (IChemFile)object;
            IChemSequence chemSeq = object.getBuilder().newInstance(IChemSequence.class, new Object[0]);
            IChemModel chemModel = object.getBuilder().newInstance(IChemModel.class, new Object[0]);
            IMoleculeSet molSet = object.getBuilder().newInstance(IMoleculeSet.class, new Object[0]);
            try {
                molSet = this.readMoleculeSet(molSet);
            }
            catch (IOException e) {
                logger.error("Input/Output error while reading from input.");
            }
            chemModel.setMoleculeSet(molSet);
            chemSeq.addChemModel(chemModel);
            chemFile.addChemSequence(chemSeq);
            return (T)chemFile;
        }
        throw new CDKException("Only supported is reading of IMoleculeSet.");
    }

    private IMoleculeSet readMoleculeSet(IMoleculeSet molSet) throws IOException {
        SmilesParser parser = new SmilesParser(molSet.getBuilder());
        parser.setPreservingAromaticity(true);
        String line = this.input.readLine();
        line = this.input.readLine();
        while (line != null) {
            String[] cols = line.split(",");
            try {
                IMolecule mol = parser.parseSmiles(cols[1]);
                mol.setProperty("focusSupport", cols[5]);
                mol.setProperty("complementSupport", cols[7]);
                mol.setProperty("atomCount", cols[2]);
                mol.setProperty("bondCount", cols[3]);
                molSet.addMolecule(mol);
            }
            catch (InvalidSmilesException exception) {
                logger.error("Skipping invalid SMILES: " + cols[1]);
                logger.debug(exception);
            }
            line = this.input.readLine();
        }
        return molSet;
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.input.close();
    }
}

