/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.Crystal;
import org.openscience.cdk.MoleculeSet;
import org.openscience.cdk.ReactionSet;
import org.openscience.cdk.RingSet;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.interfaces.IRingSet;

public class ChemModel
extends ChemObject
implements Serializable,
IChemModel,
IChemObjectListener,
Cloneable {
    private static final long serialVersionUID = -5213425310451366185L;
    protected IAtomContainerSet setOfMolecules = null;
    protected IReactionSet setOfReactions = null;
    protected IRingSet ringSet = null;
    protected ICrystal crystal = null;

    public IAtomContainerSet getMoleculeSet() {
        return this.setOfMolecules;
    }

    public void setMoleculeSet(IAtomContainerSet setOfMolecules) {
        if (this.setOfMolecules != null) {
            this.setOfMolecules.removeListener(this);
        }
        this.setOfMolecules = setOfMolecules;
        if (this.setOfMolecules != null) {
            this.setOfMolecules.addListener(this);
        }
        this.notifyChanged();
    }

    public IRingSet getRingSet() {
        return this.ringSet;
    }

    public void setRingSet(IRingSet ringSet) {
        if (this.ringSet != null) {
            this.ringSet.removeListener(this);
        }
        this.ringSet = ringSet;
        if (this.ringSet != null) {
            this.ringSet.addListener(this);
        }
        this.notifyChanged();
    }

    public ICrystal getCrystal() {
        return this.crystal;
    }

    public void setCrystal(ICrystal crystal) {
        if (this.crystal != null) {
            this.crystal.removeListener(this);
        }
        this.crystal = crystal;
        if (this.crystal != null) {
            this.crystal.addListener(this);
        }
        this.notifyChanged();
    }

    public IReactionSet getReactionSet() {
        return this.setOfReactions;
    }

    public void setReactionSet(IReactionSet sor) {
        if (this.setOfReactions != null) {
            this.setOfReactions.removeListener(this);
        }
        this.setOfReactions = sor;
        if (this.setOfReactions != null) {
            this.setOfReactions.addListener(this);
        }
        this.notifyChanged();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("ChemModel(");
        buffer.append(this.hashCode());
        if (this.getMoleculeSet() != null) {
            buffer.append(", ");
            buffer.append(this.getMoleculeSet().toString());
        }
        if (this.getCrystal() != null) {
            buffer.append(", ");
            buffer.append(this.getCrystal().toString());
        }
        if (this.getReactionSet() != null) {
            buffer.append(", ");
            buffer.append(this.getReactionSet().toString());
        }
        buffer.append(')');
        return buffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        ChemModel clone = (ChemModel)super.clone();
        clone.setOfMolecules = this.setOfMolecules != null ? (MoleculeSet)((MoleculeSet)this.setOfMolecules).clone() : null;
        clone.setOfReactions = this.setOfReactions != null ? (IReactionSet)((ReactionSet)this.setOfReactions).clone() : null;
        clone.crystal = this.crystal != null ? (Crystal)((Crystal)this.crystal).clone() : null;
        clone.ringSet = this.ringSet != null ? (RingSet)((RingSet)this.ringSet).clone() : null;
        return clone;
    }

    public void stateChanged(IChemObjectChangeEvent event) {
        this.notifyChanged(event);
    }
}

