/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.mcsplus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smsd.algorithm.mcgregor.McGregor;
import org.openscience.cdk.smsd.algorithm.mcsplus.BKKCKCF;
import org.openscience.cdk.smsd.algorithm.mcsplus.ExactMapping;
import org.openscience.cdk.smsd.algorithm.mcsplus.GenerateCompatibilityGraph;
import org.openscience.cdk.smsd.global.TimeOut;
import org.openscience.cdk.smsd.tools.TimeManager;

@TestClass(value="org.openscience.cdk.smsd.SMSDBondSensitiveTest")
public class MCSPlus {
    private static TimeManager timeManager = null;

    protected static synchronized double getTimeout() {
        return TimeOut.getInstance().getTimeOut();
    }

    protected static synchronized TimeManager getTimeManager() {
        return timeManager;
    }

    protected static synchronized void setTimeManager(TimeManager aTimeManager) {
        TimeOut.getInstance().setTimeOutFlag(false);
        timeManager = aTimeManager;
    }

    protected List<List<Integer>> getOverlaps(IAtomContainer ac1, IAtomContainer ac2, boolean shouldMatchBonds) throws CDKException {
        Stack<List<Integer>> maxCliqueSet = null;
        List<List<Integer>> mappings = new ArrayList<List<Integer>>();
        try {
            GenerateCompatibilityGraph gcg = new GenerateCompatibilityGraph(ac1, ac2, shouldMatchBonds);
            List<Integer> comp_graph_nodes = gcg.getCompGraphNodes();
            List<Integer> C_edges = gcg.getCEgdes();
            List<Integer> D_edges = gcg.getDEgdes();
            BKKCKCF init = new BKKCKCF(comp_graph_nodes, C_edges, D_edges);
            maxCliqueSet = init.getMaxCliqueSet();
            gcg.clear();
            while (!maxCliqueSet.empty()) {
                List<Integer> clique_List = maxCliqueSet.peek();
                int clique_size = clique_List.size();
                if (clique_size < ac1.getAtomCount() && clique_size < ac2.getAtomCount()) {
                    McGregor mgit = new McGregor(ac1, ac2, mappings, shouldMatchBonds);
                    mgit.startMcGregorIteration(mgit.getMCSSize(), clique_List, comp_graph_nodes);
                    mappings = mgit.getMappings();
                    mgit = null;
                } else {
                    mappings = ExactMapping.extractMapping(mappings, comp_graph_nodes, clique_List);
                }
                maxCliqueSet.pop();
                if (!MCSPlus.isTimeOut()) continue;
                break;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(MCSPlus.class.getName()).log(Level.SEVERE, null, ex);
        }
        return mappings;
    }

    public static synchronized boolean isTimeOut() {
        if (MCSPlus.getTimeout() > -1.0 && MCSPlus.getTimeManager().getElapsedTimeInMinutes() > MCSPlus.getTimeout()) {
            TimeOut.getInstance().setTimeOutFlag(true);
            return true;
        }
        return false;
    }
}

