/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.tools.diff.ChemObjectDiff;
import org.openscience.cdk.tools.diff.tree.ChemObjectDifference;
import org.openscience.cdk.tools.diff.tree.IDifference;
import org.openscience.cdk.tools.diff.tree.IntegerDifference;
import org.openscience.cdk.tools.diff.tree.StringDifference;

@TestClass(value="org.openscience.cdk.tools.diff.ElementDiffTest")
public class ElementDiff {
    @TestMethod(value="testMatchAgainstItself,testDiff")
    public static String diff(IChemObject first, IChemObject second) {
        IDifference difference = ElementDiff.difference(first, second);
        if (difference == null) {
            return "";
        }
        return difference.toString();
    }

    @TestMethod(value="testDifference")
    public static IDifference difference(IChemObject first, IChemObject second) {
        if (!(first instanceof IElement) || !(second instanceof IElement)) {
            return null;
        }
        IElement firstElem = (IElement)first;
        IElement secondElem = (IElement)second;
        ChemObjectDifference coDiff = new ChemObjectDifference("ElementDiff");
        coDiff.addChild(StringDifference.construct("S", firstElem.getSymbol(), secondElem.getSymbol()));
        coDiff.addChild(StringDifference.construct("ID", firstElem.getID(), secondElem.getID()));
        coDiff.addChild(IntegerDifference.construct("AN", firstElem.getAtomicNumber(), secondElem.getAtomicNumber()));
        coDiff.addChild(ChemObjectDiff.difference(first, second));
        if (coDiff.childCount() > 0) {
            return coDiff;
        }
        return null;
    }
}

