/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.stereo;

import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.ITetrahedralChirality;

public class TetrahedralChirality
implements ITetrahedralChirality {
    private IAtom chiralAtom;
    private IAtom[] ligandAtoms;
    private ITetrahedralChirality.Stereo stereo;

    public TetrahedralChirality(IAtom chiralAtom, IAtom[] ligandAtoms, ITetrahedralChirality.Stereo chirality) {
        this.chiralAtom = chiralAtom;
        this.ligandAtoms = ligandAtoms;
        this.stereo = chirality;
    }

    @Override
    public IAtom[] getLigands() {
        IAtom[] arrayCopy = new IAtom[4];
        System.arraycopy(this.ligandAtoms, 0, arrayCopy, 0, 4);
        return arrayCopy;
    }

    @Override
    public IAtom getChiralAtom() {
        return this.chiralAtom;
    }

    @Override
    public ITetrahedralChirality.Stereo getStereo() {
        return this.stereo;
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return DefaultChemObjectBuilder.getInstance();
    }
}

