/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.selection;

import java.util.Collection;
import java.util.HashSet;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.renderer.selection.AbstractSelection;

public class MultiSelection<T extends IChemObject>
extends AbstractSelection {
    Collection<T> selection;

    public MultiSelection(Collection<T> selection) {
        this.selection = selection;
    }

    @Override
    public IAtomContainer getConnectedAtomContainer() {
        IAtomContainer atomContainer = null;
        if (!this.selection.isEmpty()) {
            for (IChemObject value : this.selection) {
                if (atomContainer == null) {
                    atomContainer = (IAtomContainer)value.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
                }
                this.addToAtomContainer(atomContainer, value);
            }
        }
        return atomContainer;
    }

    @Override
    public boolean isFilled() {
        return !this.selection.isEmpty();
    }

    @Override
    public boolean contains(IChemObject obj) {
        if (obj == null) {
            return false;
        }
        for (IChemObject selected : this.selection) {
            if (selected != obj) continue;
            return true;
        }
        return false;
    }

    @Override
    public <E extends IChemObject> Collection<E> elements(Class<E> clazz) {
        HashSet<Object> set = new HashSet<Object>();
        if (clazz.isAssignableFrom(IChemObject.class)) {
            set.addAll(this.selection);
            return set;
        }
        for (IChemObject obj : this.selection) {
            if (!clazz.isAssignableFrom(obj.getClass())) continue;
            set.add(obj);
        }
        return set;
    }
}

