/*
 * Decompiled with CFR 0.152.
 */
package signature.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import signature.ColoredTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplayableColoredTree {
    public int maxDepth;
    private DrawNode root;
    private Map<Integer, Color> colorMap;
    private int width;
    private int height;
    private boolean drawKey;

    public DisplayableColoredTree(int width, int height) {
        this.root = null;
        this.width = width;
        this.height = height;
        this.drawKey = false;
    }

    public DisplayableColoredTree(ColoredTree tree, int width, int height) {
        this.width = width;
        this.height = height;
        this.makeFromColoredTree(tree);
        this.colorMap = this.makeColorMap(tree.numberOfColors());
        this.drawKey = false;
    }

    public void setDrawKey(boolean drawKey) {
        this.drawKey = drawKey;
    }

    private Map<Integer, Color> makeColorMap(int max) {
        HashMap<Integer, Color> colorMap = new HashMap<Integer, Color>();
        for (int i = 0; i <= max; ++i) {
            colorMap.put(i, this.colourRamp(i, 0, max));
        }
        return colorMap;
    }

    public void makeFromColoredTree(ColoredTree tree) {
        this.root = this.treeToTree(tree);
        this.maxDepth = tree.getHeight();
        this.colorMap = this.makeColorMap(tree.numberOfColors());
    }

    private DrawNode treeToTree(ColoredTree tree) {
        return this.treeToTree(tree.getRoot(), null);
    }

    private DrawNode treeToTree(ColoredTree.Node treeNode, DrawNode parent) {
        DrawNode node = treeNode.edgeLabel == "" ? new DrawNode(treeNode.label, parent, treeNode.height, treeNode.color) : new DrawNode(treeNode.label, parent, treeNode.height, treeNode.color, treeNode.edgeLabel);
        if (parent != null) {
            parent.children.add(node);
        }
        node.parent = parent;
        for (ColoredTree.Node child : treeNode.children) {
            this.treeToTree(child, node);
        }
        return node;
    }

    public void paint(Graphics g) {
        if (this.root == null) {
            return;
        }
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.width, this.height);
        if (this.drawKey) {
            this.paintKey(g);
        }
        new TreeLayout().layoutTree(this.root, this.width, this.height);
        g.setColor(Color.BLACK);
        this.paint(g, this.root);
    }

    public void paintKey(Graphics g) {
        int xoffset = 10;
        int boxsize = 25;
        int y = 5;
        int colors = this.colorMap.size();
        int x = xoffset;
        for (int i = 0; i < colors; ++i) {
            Color color = this.colorMap.get(i);
            g.setColor(color);
            g.fillRect(x, y, boxsize, boxsize);
            g.setColor(Color.BLACK);
            g.drawString(i + "", x + boxsize / 3, y + boxsize / 2);
            x += boxsize;
        }
    }

    public void paint(Graphics g, DrawNode node) {
        for (DrawNode child : node.children) {
            g.drawLine(node.x, node.y, child.x, child.y);
            this.paint(g, child);
        }
        String label = node.edgeLabel + node.label;
        Rectangle2D r = g.getFontMetrics().getStringBounds(label, g);
        int rw = (int)r.getWidth();
        int rh = (int)r.getHeight();
        int textX = node.x - rw / 2;
        int textY = node.y + rh / 2;
        int border = 3;
        int boundX = textX - border;
        int boundY = node.y - rh / 2 - border;
        int boundW = rw + 2 * border;
        int boundH = rh + 2 * border;
        if (this.colorMap.containsKey(node.color)) {
            g.setColor(this.colorMap.get(node.color));
        } else {
            g.setColor(Color.WHITE);
        }
        g.fillRect(boundX, boundY, boundW, boundH);
        g.setColor(Color.BLACK);
        g.drawRect(boundX, boundY, boundW, boundH);
        g.drawString(label, textX, textY);
    }

    private Color colourRamp(int v, int vmin, int vmax) {
        double r = 1.0;
        double g = 1.0;
        double b = 1.0;
        if (v < vmin) {
            v = vmin;
        }
        if (v > vmax) {
            v = vmax;
        }
        int dv = vmax - vmin;
        try {
            if ((double)v < (double)vmin + 0.25 * (double)dv) {
                r = 0.0;
                g = 4.0 * (double)(v - vmin) / (double)dv;
            } else if ((double)v < (double)vmin + 0.5 * (double)dv) {
                r = 0.0;
                b = 1.0 + 4.0 * ((double)vmin + 0.25 * (double)dv - (double)v) / (double)dv;
            } else if ((double)v < (double)vmin + 0.75 * (double)dv) {
                r = 4.0 * ((double)(v - vmin) - 0.5 * (double)dv) / (double)dv;
                b = 0.0;
            } else {
                g = 1.0 + 4.0 * ((double)vmin + 0.75 * (double)dv - (double)v) / (double)dv;
                b = 0.0;
            }
            float[] hsb = Color.RGBtoHSB((int)(r * 255.0), (int)(g * 255.0), (int)(b * 255.0), null);
            return Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
        }
        catch (ArithmeticException zde) {
            float[] hsb = Color.RGBtoHSB(0, 0, 0, null);
            return Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
        }
    }

    public class DrawNode {
        public int x = -1;
        public int y = -1;
        public int depth;
        public int color;
        public List<DrawNode> children = new ArrayList<DrawNode>();
        public String label;
        public DrawNode parent;
        public String edgeLabel;

        public DrawNode(String label, DrawNode parent, int d, int color) {
            this.label = label;
            this.parent = parent;
            this.depth = d;
            this.color = color;
            this.edgeLabel = "";
        }

        public DrawNode(String label, DrawNode parent, int d, int color, String edgeLabel) {
            this(label, parent, d, color);
            this.edgeLabel = edgeLabel;
        }

        public int countLeaves() {
            if (this.isLeaf()) {
                return 1;
            }
            int c = 0;
            for (DrawNode child : this.children) {
                c += child.countLeaves();
            }
            return c;
        }

        public boolean isLeaf() {
            return this.children.size() == 0;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            this.toString(buffer);
            return buffer.toString();
        }

        private void toString(StringBuffer buffer) {
            buffer.append(this.label);
            buffer.append('[').append(this.x).append(',').append(this.y).append(']');
            for (DrawNode child : this.children) {
                child.toString(buffer);
            }
        }
    }

    public class TreeLayout {
        public int totalLeafCount = 0;
        public int xSep;
        public int ySep;

        public void layoutTree(DrawNode root, int width, int height) {
            int leafCount = root.countLeaves();
            this.xSep = width / (leafCount + 1);
            this.ySep = height / (DisplayableColoredTree.this.maxDepth + 1);
            this.layout(root);
        }

        public int layout(DrawNode node) {
            node.y = node.depth * this.ySep;
            if (node.isLeaf()) {
                ++this.totalLeafCount;
                node.x = this.totalLeafCount * this.xSep;
                return node.x;
            }
            int min = 0;
            int max = 0;
            for (DrawNode child : node.children) {
                int childCenter = this.layout(child);
                if (min == 0) {
                    min = childCenter;
                }
                max = childCenter;
            }
            node.x = min == max ? min : min + (max - min) / 2;
            return node.x;
        }
    }
}

