/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.matchers;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.smsd.algorithm.matchers.VFAtomMatcher;
import org.openscience.cdk.smsd.algorithm.vflib.builder.TargetProperties;

@TestClass(value="org.openscience.cdk.smsd.algorithm.vflib.VFLibTest")
public class DefaultVFAtomMatcher
implements VFAtomMatcher {
    static final long serialVersionUID = -7861469841127327812L;
    private int maximumNeighbors = -1;
    private String symbol = null;
    private IAtom qAtom = null;
    private IQueryAtom smartQueryAtom = null;
    private boolean shouldMatchBonds = false;

    public boolean isBondMatchFlag() {
        return this.shouldMatchBonds;
    }

    public final void setBondMatchFlag(boolean shouldMatchBonds) {
        this.shouldMatchBonds = shouldMatchBonds;
    }

    public DefaultVFAtomMatcher() {
    }

    public DefaultVFAtomMatcher(IAtomContainer queryContainer, IAtom atom, boolean shouldMatchBonds) {
        this();
        this.qAtom = atom;
        this.symbol = atom.getSymbol();
        this.setBondMatchFlag(shouldMatchBonds);
    }

    public DefaultVFAtomMatcher(IQueryAtom smartQueryAtom, IQueryAtomContainer container) {
        this();
        this.smartQueryAtom = smartQueryAtom;
        this.symbol = smartQueryAtom.getSymbol();
    }

    public DefaultVFAtomMatcher(IAtomContainer queryContainer, IAtom template, int blockedPositions, boolean shouldMatchBonds) {
        this(queryContainer, template, shouldMatchBonds);
        this.maximumNeighbors = this.countImplicitHydrogens(template) + queryContainer.getConnectedAtomsCount(template) - blockedPositions;
    }

    public void setMaximumNeighbors(int maximum) {
        this.maximumNeighbors = maximum;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    private boolean matchSymbol(IAtom atom) {
        if (this.symbol == null) {
            return false;
        }
        return this.symbol.equals(atom.getSymbol());
    }

    private boolean matchMaximumNeighbors(TargetProperties targetContainer, IAtom targetAtom) {
        if (this.maximumNeighbors == -1 || !this.isBondMatchFlag()) {
            return true;
        }
        int maximumTargetNeighbors = targetContainer.countNeighbors(targetAtom);
        return maximumTargetNeighbors <= this.maximumNeighbors;
    }

    private int countImplicitHydrogens(IAtom atom) {
        return atom.getImplicitHydrogenCount() == null ? 0 : atom.getImplicitHydrogenCount();
    }

    @Override
    public boolean matches(TargetProperties targetContainer, IAtom targetAtom) {
        if (this.smartQueryAtom != null && this.qAtom == null) {
            if (!this.smartQueryAtom.matches(targetAtom)) {
                return false;
            }
        } else {
            if (!this.matchSymbol(targetAtom)) {
                return false;
            }
            if (!this.matchMaximumNeighbors(targetContainer, targetAtom)) {
                return false;
            }
        }
        return true;
    }
}

