/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.IResourceFormat;

@TestClass(value="org.openscience.cdk.io.formats.MDLFormatTest")
public class MDLFormat
implements IChemFormatMatcher {
    private static IResourceFormat myself = null;

    private MDLFormat() {
    }

    @TestMethod(value="testResourceFormatSet")
    public static IResourceFormat getInstance() {
        if (myself == null) {
            myself = new MDLFormat();
        }
        return myself;
    }

    @Override
    @TestMethod(value="testGetFormatName")
    public String getFormatName() {
        return "MDL Molfile";
    }

    @Override
    @TestMethod(value="testGetMIMEType")
    public String getMIMEType() {
        return "chemical/x-mdl-molfile";
    }

    @Override
    @TestMethod(value="testGetPreferredNameExtension")
    public String getPreferredNameExtension() {
        return this.getNameExtensions()[0];
    }

    @Override
    @TestMethod(value="testGetNameExtensions")
    public String[] getNameExtensions() {
        return new String[]{"mol"};
    }

    @Override
    @TestMethod(value="testGetReaderClassName")
    public String getReaderClassName() {
        return "org.openscience.cdk.io.MDLReader";
    }

    @Override
    @TestMethod(value="testGetWriterClassName")
    public String getWriterClassName() {
        return null;
    }

    @Override
    public boolean matches(int lineNumber, String line) {
        if (lineNumber == 4 && line.length() > 7 && line.indexOf("2000") == -1 && line.indexOf("3000") == -1) {
            try {
                String atomCountString = line.substring(0, 3).trim();
                String bondCountString = line.substring(3, 6).trim();
                Integer.valueOf(atomCountString);
                Integer.valueOf(bondCountString);
                if (line.length() > 6) {
                    String remainder = line.substring(6).trim();
                    for (int i = 0; i < remainder.length(); ++i) {
                        char c = remainder.charAt(i);
                        if (Character.isDigit(c) || Character.isWhitespace(c)) continue;
                        return false;
                    }
                }
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    @TestMethod(value="testIsXMLBased")
    public boolean isXMLBased() {
        return false;
    }

    @Override
    @TestMethod(value="testGetSupportedDataFeatures")
    public int getSupportedDataFeatures() {
        return this.getRequiredDataFeatures() | 1 | 2 | 0x200;
    }

    @Override
    @TestMethod(value="testGetRequiredDataFeatures")
    public int getRequiredDataFeatures() {
        return 8;
    }
}

