/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph.invariant;

import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;

@TestClass(value="org.openscience.cdk.graph.invariant.MorganNumbersToolsTest")
public class MorganNumbersTools {
    @TestMethod(value="testGetMorganNumbers_IAtomContainer")
    public static long[] getMorganNumbers(IAtomContainer atomContainer) {
        int N = atomContainer.getAtomCount();
        long[] morganMatrix = new long[N];
        long[] tempMorganMatrix = new long[N];
        for (int f = 0; f < N; ++f) {
            morganMatrix[f] = atomContainer.getConnectedBondsCount(f);
            tempMorganMatrix[f] = atomContainer.getConnectedBondsCount(f);
        }
        for (int e = 0; e < N; ++e) {
            for (int f = 0; f < N; ++f) {
                morganMatrix[f] = 0L;
                List<IAtom> atoms = atomContainer.getConnectedAtomsList(atomContainer.getAtom(f));
                for (IAtom atom : atoms) {
                    int n = f;
                    morganMatrix[n] = morganMatrix[n] + tempMorganMatrix[atomContainer.getAtomNumber(atom)];
                }
            }
            System.arraycopy(morganMatrix, 0, tempMorganMatrix, 0, N);
        }
        return tempMorganMatrix;
    }

    @TestMethod(value="testPhenylamine")
    public static String[] getMorganNumbersWithElementSymbol(IAtomContainer atomContainer) {
        long[] morgannumbers = MorganNumbersTools.getMorganNumbers(atomContainer);
        String[] morgannumberswithelement = new String[morgannumbers.length];
        for (int i = 0; i < morgannumbers.length; ++i) {
            morgannumberswithelement[i] = atomContainer.getAtom(i).getSymbol() + "-" + morgannumbers[i];
        }
        return morgannumberswithelement;
    }
}

