/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;

@TestClass(value="org.openscience.cdk.formula.IsotopeContainerTest")
public class IsotopeContainer {
    private IMolecularFormula form;
    private double masOs;
    private double inte;

    public IsotopeContainer() {
    }

    @TestMethod(value="testIsotopeContainer_IMolecularFormula_double")
    public IsotopeContainer(IMolecularFormula formula, double intensity) {
        this.form = formula;
        if (formula != null) {
            this.masOs = MolecularFormulaManipulator.getTotalExactMass(formula);
        }
        this.inte = intensity;
    }

    @TestMethod(value="testIsotopeContainer_double_double")
    public IsotopeContainer(double mass, double intensity) {
        this.masOs = mass;
        this.inte = intensity;
    }

    @TestMethod(value="testSetFormula_IMolecularFormula")
    public void setFormula(IMolecularFormula formula) {
        this.form = formula;
    }

    @TestMethod(value="testSetMass_double")
    public void setMass(double mass) {
        this.masOs = mass;
    }

    @TestMethod(value="testSetIntensity_double")
    public void setIntensity(double intensity) {
        this.inte = intensity;
    }

    @TestMethod(value="testGetFormula")
    public IMolecularFormula getFormula() {
        return this.form;
    }

    @TestMethod(value="testGetMass")
    public double getMass() {
        return this.masOs;
    }

    @TestMethod(value="testGetIntensity")
    public double getIntensity() {
        return this.inte;
    }

    @TestMethod(value="testClone")
    public Object clone() throws CloneNotSupportedException {
        IsotopeContainer isoClone = new IsotopeContainer();
        isoClone.setFormula(this.getFormula());
        isoClone.setIntensity(this.getIntensity());
        isoClone.setMass(this.getMass());
        return isoClone;
    }
}

