/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.graph.invariant.IChIGenerator;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class CreateIChIAction
extends JCPAction {
    private static final long serialVersionUID = 128287423627104971L;
    JFrame frame;

    public void actionPerformed(ActionEvent e) {
        logger.debug((Object)"Trying to create IChI: ", (Object)this.type);
        IChIGenerator generator = new IChIGenerator();
        String IChI = "";
        logger.debug((Object)"IChI = ", (Object)IChI);
        try {
            ChemModel model = (ChemModel)this.jcpPanel.getJChemPaintModel().getChemModel();
            IAtomContainer container = ChemModelManipulator.getAllInOneContainer((IChemModel)model);
            Molecule molecule = new Molecule(container);
            logger.debug((Object)"Before runing IChI generater: ");
            IChI = generator.createIChI(molecule);
            String message = "Generated IChI: " + IChI;
            logger.debug((Object)message);
            this.frame = new TextFrame(IChI);
            this.frame.pack();
            this.frame.setVisible(true);
        }
        catch (Exception exc) {
            logger.error((Object)exc.toString());
        }
    }

    private class TextFrame
    extends JFrame {
        private static final long serialVersionUID = 8998255443644195659L;

        public TextFrame(String ichi) {
            super("IChI");
            JTextArea textArea = new JTextArea(ichi);
            textArea.setFont(new Font("Serif", 2, 16));
            textArea.setLineWrap(true);
            textArea.setWrapStyleWord(true);
            JScrollPane areaScrollPane = new JScrollPane(textArea);
            areaScrollPane.setVerticalScrollBarPolicy(22);
            areaScrollPane.setPreferredSize(new Dimension(500, 500));
            areaScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("IChI string"), BorderFactory.createEmptyBorder(5, 5, 5, 5)), areaScrollPane.getBorder()));
            JPanel contentPane = new JPanel();
            BoxLayout box = new BoxLayout(contentPane, 0);
            contentPane.setLayout(box);
            contentPane.add(areaScrollPane);
            this.setContentPane(contentPane);
        }

        public void closeFrame() {
            this.dispose();
        }
    }
}

