/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.net.URL;
import java.util.MissingResourceException;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.openscience.cdk.applications.jchempaint.JCPLocalizationHandler;
import org.openscience.cdk.applications.jchempaint.JCPPropertyHandler;
import org.openscience.cdk.applications.jchempaint.JChemPaintPanel;
import org.openscience.cdk.applications.jchempaint.StringHelper;
import org.openscience.cdk.applications.jchempaint.action.ElementAction;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.tools.LoggingTool;

public class ToolBarMaker {
    private static LoggingTool logger;
    static /* synthetic */ Class class$org$openscience$cdk$applications$jchempaint$ToolBarMaker;

    public static JToolBar getToolbar(JChemPaintPanel jcpp, int lines) {
        if (logger == null) {
            logger = new LoggingTool(class$org$openscience$cdk$applications$jchempaint$ToolBarMaker == null ? (class$org$openscience$cdk$applications$jchempaint$ToolBarMaker = ToolBarMaker.class$("org.openscience.cdk.applications.jchempaint.ToolBarMaker")) : class$org$openscience$cdk$applications$jchempaint$ToolBarMaker);
        }
        JToolBar maintoolbar = (JToolBar)ToolBarMaker.createToolbar(0, "toolbar", jcpp, lines, false);
        JToolBar elementtoolbar = (JToolBar)ToolBarMaker.createToolbar(0, "elementtoolbar", jcpp, lines * 2, true);
        maintoolbar.add(elementtoolbar);
        return maintoolbar;
    }

    static String getToolbarResourceString(String key) {
        String str;
        try {
            str = JCPPropertyHandler.getInstance().getGUIDefinition().getString(key);
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    static JButton createToolbarButton(String key, JChemPaintPanel jcpp, boolean elementtype) {
        JCPPropertyHandler jcpph = JCPPropertyHandler.getInstance();
        JButton b = null;
        if (!elementtype) {
            JCPAction a;
            logger.debug((Object)"Trying to find resource for key: ", (Object)key);
            URL url = jcpph.getResource(key + "Image");
            logger.debug((Object)"Trying to find resource: ", (Object)url);
            if (url == null) {
                logger.error((Object)"Cannot find resource: ", (Object)key, (Object)"Image");
                return null;
            }
            ImageIcon image = new ImageIcon(url);
            if (image == null) {
                logger.error((Object)"Cannot find image: ", (Object)url);
                return null;
            }
            b = new JButton(image){
                private static final long serialVersionUID = 1478990892406874403L;

                public float getAlignmentY() {
                    return 0.5f;
                }
            };
            String astr = jcpph.getResourceString(key + "Action");
            if (astr == null) {
                astr = key;
            }
            if ((a = new JCPAction().getAction(jcpp, astr)) != null) {
                b.setActionCommand(astr);
                logger.debug((Object)"Coupling action to button...");
                b.addActionListener(a);
                b.setEnabled(a.isEnabled());
            } else {
                logger.error((Object)"Could not find JCPAction class for:", (Object)astr);
                b.setEnabled(false);
            }
            try {
                String tip = JCPLocalizationHandler.getInstance().getString(key + "Tooltip");
                if (tip != null) {
                    b.setToolTipText(tip);
                }
            }
            catch (MissingResourceException e) {
                logger.warn((Object)"Could not find Tooltip resource for: ", (Object)key);
                logger.debug((Object)e);
            }
        } else {
            b = new JButton(key);
            ElementAction a = new ElementAction(key, jcpp);
            b.addActionListener(a);
            b.setEnabled(a.isEnabled());
            if (JCPLocalizationHandler.getInstance().getString("singleelementTooltip") != null) {
                b.setToolTipText(JCPLocalizationHandler.getInstance().getString("singleelementTooltip") + " " + key);
            }
            b.setSize(30, 15);
            b.setPreferredSize(new Dimension(30, 15));
            b.setMaximumSize(new Dimension(30, 15));
        }
        b.setRequestFocusEnabled(false);
        b.setMargin(new Insets(1, 1, 1, 1));
        if (key.equals("bond")) {
            jcpp.lastAction.add(b);
        }
        if (key.equals("move")) {
            jcpp.moveButton = b;
        }
        return b;
    }

    public static Component createToolbar(int orientation, String kind, JChemPaintPanel jcpp, int lines, boolean elementtype) {
        JToolBar toolbar2 = new JToolBar(orientation);
        String[] toolKeys = StringHelper.tokenize(ToolBarMaker.getToolbarResourceString(kind));
        JButton button = null;
        if (toolKeys.length != 0) {
            String[] sdiToolKeys = new String[toolKeys.length];
            for (int i = 0; i < toolKeys.length; ++i) {
                int j = i - 0;
                sdiToolKeys[j] = toolKeys[i];
            }
            toolKeys = sdiToolKeys;
        }
        Box box = null;
        int counter = 0;
        for (int i = 0; i < toolKeys.length; ++i) {
            if (toolKeys[i].equals("-")) {
                toolbar2.add(box);
                if (orientation == 0) {
                    toolbar2.add(Box.createHorizontalStrut(5));
                } else if (orientation == 1) {
                    toolbar2.add(Box.createVerticalStrut(5));
                }
                counter = 0;
                continue;
            }
            if (counter % lines == 0) {
                if (box != null) {
                    toolbar2.add(box);
                }
                box = new Box(1);
            }
            if ((button = ToolBarMaker.createToolbarButton(toolKeys[i], jcpp, elementtype)) != null) {
                box.add(button);
                if (toolKeys[i].equals("bond") && !elementtype) {
                    button.setBackground(Color.GRAY);
                } else {
                    button.setBackground(Color.LIGHT_GRAY);
                }
            } else {
                logger.error((Object)("Could not create button" + toolKeys[i]));
            }
            ++counter;
        }
        if (box != null) {
            toolbar2.add(box);
        }
        if (orientation == 0) {
            toolbar2.add(Box.createHorizontalGlue());
        }
        return toolbar2;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

