/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

class PropertyManager {
    Viewer viewer;
    static final String[] propertyTypes = new String[]{"appletInfo", "", "", "fileName", "", "", "fileHeader", "", "", "fileContents", "", "", "fileContents", "<pathname>", "", "animationInfo", "", "", "modelInfo", "", "", "X -vibrationInfo", "", "", "shapeInfo", "", "", "measurementInfo", "", "", "centerInfo", "", "", "orientationInfo", "", "", "transformInfo", "", "", "atomList", "<atom selection>", "visible", "atomInfo", "<atom selection>", "visible", "bondInfo", "<atom selection>", "visible", "chainInfo", "<atom selection>", "visible", "polymerInfo", "<atom selection>", "visible", "moleculeInfo", "<atom selection>", "visible", "stateInfo", "<atom selection>", "visible", "extractModel", "<atom selection>", "visible", "jmolStatus", "statusNameList", "", "jmolViewer", "", "", "messageQueue", "", "", "auxiliaryInfo", "", "", "boundBoxInfo", "", "", "dataInfo", "<data type>", "types", "image", "", ""};
    static final int PROP_APPLET_INFO = 0;
    static final int PROP_FILENAME = 1;
    static final int PROP_FILEHEADER = 2;
    static final int PROP_FILECONTENTS = 3;
    static final int PROP_FILECONTENTS_PATH = 4;
    static final int PROP_ANIMATION_INFO = 5;
    static final int PROP_MODEL_INFO = 6;
    static final int PROP_VIBRATION_INFO = 7;
    static final int PROP_SHAPE_INFO = 8;
    static final int PROP_MEASUREMENT_INFO = 9;
    static final int PROP_CENTER_INFO = 10;
    static final int PROP_ORIENTATION_INFO = 11;
    static final int PROP_TRANSFORM_INFO = 12;
    static final int PROP_ATOM_LIST = 13;
    static final int PROP_ATOM_INFO = 14;
    static final int PROP_BOND_INFO = 15;
    static final int PROP_CHAIN_INFO = 16;
    static final int PROP_POLYMER_INFO = 17;
    static final int PROP_MOLECULE_INFO = 18;
    static final int PROP_STATE_INFO = 19;
    static final int PROP_EXTRACT_MODEL = 20;
    static final int PROP_JMOL_STATUS = 21;
    static final int PROP_JMOL_VIEWER = 22;
    static final int PROP_MESSAGE_QUEUE = 23;
    static final int PROP_AUXILIARY_INFO = 24;
    static final int PROP_BOUNDBOX_INFO = 25;
    static final int PROP_DATA_INFO = 26;
    static final int PROP_IMAGE = 27;
    static final int PROP_COUNT = 28;
    static final String[] readableTypes = new String[]{"extractmodel", "filecontents", "fileheader", "image"};
    boolean requestedReadable = false;

    PropertyManager(Viewer viewer) {
        this.viewer = viewer;
    }

    int getPropertyNumber(String infoType) {
        if (infoType == null) {
            return -1;
        }
        for (int i = 0; i < 28; ++i) {
            if (!infoType.equalsIgnoreCase(this.getPropertyName(i))) continue;
            return i;
        }
        return -1;
    }

    String getPropertyName(int propID) {
        if (propID < 0) {
            return "";
        }
        return propertyTypes[propID * 3];
    }

    String getParamType(int propID) {
        if (propID < 0) {
            return "";
        }
        return propertyTypes[propID * 3 + 1];
    }

    String getDefaultParam(int propID) {
        if (propID < 0) {
            return "";
        }
        return propertyTypes[propID * 3 + 2];
    }

    boolean isReadableAsString(String infoType) {
        int i = readableTypes.length;
        while (--i >= 0) {
            if (!infoType.equalsIgnoreCase(readableTypes[i])) continue;
            return true;
        }
        return false;
    }

    synchronized Object getProperty(String returnType, String infoType, String paramInfo) {
        if (propertyTypes.length != 84) {
            Logger.warn("propertyTypes is not the right length: " + propertyTypes.length + " != " + 84);
        }
        Object info = this.getPropertyAsObject(infoType, paramInfo);
        if (returnType == null) {
            return info;
        }
        this.requestedReadable = returnType.equalsIgnoreCase("readable");
        if (this.requestedReadable) {
            String string = returnType = this.isReadableAsString(infoType) ? "String" : "JSON";
        }
        if (returnType.equalsIgnoreCase("String")) {
            return info.toString();
        }
        if (this.requestedReadable) {
            return this.toReadable(infoType, info);
        }
        if (returnType.equalsIgnoreCase("JSON")) {
            return "{" + this.toJSON(infoType, info) + "}";
        }
        return info;
    }

    private synchronized Object getPropertyAsObject(String infoType, String paramInfo) {
        int id = this.getPropertyNumber(infoType);
        boolean iHaveParameter = paramInfo.length() > 0;
        String myParam = iHaveParameter ? paramInfo : this.getDefaultParam(id);
        switch (id) {
            case 0: {
                return this.viewer.getAppletInfo();
            }
            case 5: {
                return this.viewer.getAnimationInfo();
            }
            case 13: {
                return this.viewer.getAtomBitSetVector(myParam);
            }
            case 14: {
                return this.viewer.getAllAtomInfo(myParam);
            }
            case 24: {
                return this.viewer.getAuxiliaryInfo();
            }
            case 15: {
                return this.viewer.getAllBondInfo(myParam);
            }
            case 25: {
                return this.viewer.getBoundBoxInfo();
            }
            case 10: {
                return this.viewer.getRotationCenter();
            }
            case 16: {
                return this.viewer.getAllChainInfo(myParam);
            }
            case 20: {
                return this.viewer.getModelExtract(myParam);
            }
            case 1: {
                return this.viewer.getFullPathName();
            }
            case 2: {
                return this.viewer.getFileHeader();
            }
            case 3: 
            case 4: {
                if (iHaveParameter) {
                    return this.viewer.getFileAsString(myParam);
                }
                return this.viewer.getCurrentFileAsString();
            }
            case 21: {
                return this.viewer.getStatusChanged(myParam);
            }
            case 22: {
                return this.viewer.getViewer();
            }
            case 9: {
                return this.viewer.getMeasurementInfo();
            }
            case 23: {
                return this.viewer.getMessageQueue();
            }
            case 6: {
                return this.viewer.getModelInfo();
            }
            case 18: {
                return this.viewer.getMoleculeInfo(myParam);
            }
            case 11: {
                return this.viewer.getOrientationInfo();
            }
            case 17: {
                return this.viewer.getAllPolymerInfo(myParam);
            }
            case 8: {
                return this.viewer.getShapeInfo();
            }
            case 19: {
                return this.viewer.getAllStateInfo(myParam);
            }
            case 12: {
                return this.viewer.getMatrixRotate();
            }
            case 26: {
                return this.viewer.getData(myParam);
            }
            case 27: {
                return this.viewer.getJpegBase64(100);
            }
        }
        String info = "getProperty ERROR\n" + infoType + "?\nOptions include:\n";
        for (int i = 0; i < 28; ++i) {
            String paramType = this.getParamType(i);
            String paramDefault = this.getDefaultParam(i);
            String name = this.getPropertyName(i);
            if (name.charAt(0) == 'X') continue;
            info = info + "\n getProperty(\"" + name + "\"" + (paramType != "" ? ",\"" + paramType + (paramDefault != "" ? "[" + paramDefault + "]" : "") + "\"" : "") + ")";
        }
        return info;
    }

    String packageJSON(String infoType, String info) {
        if (infoType == null) {
            return info;
        }
        return "\"" + infoType + "\": " + info;
    }

    String packageReadable(String infoType, String info) {
        if (infoType == null) {
            return info;
        }
        return "\n" + infoType + "\t" + info;
    }

    String fixString(String s) {
        if (s == null || s.indexOf("{\"") == 0) {
            return s;
        }
        s = this.viewer.simpleReplace(s, "\"", "''");
        s = this.viewer.simpleReplace(s, "\n", " | ");
        return "\"" + s + "\"";
    }

    String toJSON(String infoType, Object info) {
        String str = "";
        String sep = "";
        if (info == null) {
            return this.packageJSON(infoType, null);
        }
        if (info instanceof String) {
            return this.packageJSON(infoType, this.fixString((String)info));
        }
        if (info instanceof String[]) {
            str = "[";
            int imax = ((String[])info).length;
            for (int i = 0; i < imax; ++i) {
                str = str + sep + this.fixString(((String[])info)[i]);
                sep = ",";
            }
            str = str + "]";
            return this.packageJSON(infoType, str);
        }
        if (info instanceof int[]) {
            str = "[";
            int imax = ((int[])info).length;
            for (int i = 0; i < imax; ++i) {
                str = str + sep + ((int[])info)[i];
                sep = ",";
            }
            str = str + "]";
            return this.packageJSON(infoType, str);
        }
        if (info instanceof float[]) {
            str = "[";
            int imax = ((float[])info).length;
            for (int i = 0; i < imax; ++i) {
                str = str + sep + ((float[])info)[i];
                sep = ",";
            }
            str = str + "]";
            return this.packageJSON(infoType, str);
        }
        if (info instanceof float[][]) {
            str = "[";
            int imax = ((float[][])info).length;
            for (int i = 0; i < imax; ++i) {
                str = str + sep + this.toJSON(null, ((float[][])info)[i]);
                sep = ",";
            }
            str = str + "]";
            return this.packageJSON(infoType, str);
        }
        if (info instanceof Vector) {
            str = "[";
            int imax = ((Vector)info).size();
            for (int i = 0; i < imax; ++i) {
                str = str + sep + this.toJSON(null, ((Vector)info).get(i));
                sep = ",";
            }
            str = str + "]";
            return this.packageJSON(infoType, str);
        }
        if (info instanceof Matrix3f) {
            str = "[";
            str = str + "[" + ((Matrix3f)info).m00 + "," + ((Matrix3f)info).m01 + "," + ((Matrix3f)info).m02 + "]";
            str = str + ",[" + ((Matrix3f)info).m10 + "," + ((Matrix3f)info).m11 + "," + ((Matrix3f)info).m12 + "]";
            str = str + ",[" + ((Matrix3f)info).m20 + "," + ((Matrix3f)info).m21 + "," + ((Matrix3f)info).m22 + "]";
            str = str + "]";
            return this.packageJSON(infoType, str);
        }
        if (info instanceof Point3f) {
            str = str + "[" + ((Point3f)info).x + "," + ((Point3f)info).y + "," + ((Point3f)info).z + "]";
            return this.packageJSON(infoType, str);
        }
        if (info instanceof Vector3f) {
            str = str + "[" + ((Vector3f)info).x + "," + ((Vector3f)info).y + "," + ((Vector3f)info).z + "]";
            return this.packageJSON(infoType, str);
        }
        if (info instanceof Hashtable) {
            str = "{";
            Enumeration e = ((Hashtable)info).keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                str = str + sep + this.packageJSON(key, this.toJSON(null, ((Hashtable)info).get(key)));
                sep = ",";
            }
            str = str + "}";
            return this.packageJSON(infoType, str);
        }
        return this.packageJSON(infoType, info.toString());
    }

    String toReadable(String infoType, Object info) {
        String str = "";
        String sep = "";
        if (info == null) {
            return "null";
        }
        if (info instanceof String) {
            return this.packageReadable(infoType, this.fixString((String)info));
        }
        if (info instanceof String[]) {
            str = "[";
            int imax = ((String[])info).length;
            for (int i = 0; i < imax; ++i) {
                str = str + sep + this.fixString(((String[])info)[i]);
                sep = ",";
            }
            str = str + "]";
            return this.packageReadable(infoType, str);
        }
        if (info instanceof int[]) {
            str = "[";
            int imax = ((int[])info).length;
            for (int i = 0; i < imax; ++i) {
                str = str + sep + ((int[])info)[i];
                sep = ",";
            }
            str = str + "]";
            return this.packageReadable(infoType, str);
        }
        if (info instanceof float[]) {
            str = "";
            int imax = ((float[])info).length;
            for (int i = 0; i < imax; ++i) {
                str = str + sep + ((float[])info)[i];
                sep = ",";
            }
            str = str + "";
            return this.packageReadable(infoType, str);
        }
        if (info instanceof float[][]) {
            str = "[";
            int imax = ((float[][])info).length;
            for (int i = 0; i < imax; ++i) {
                str = str + sep + this.toReadable(null, ((float[][])info)[i]);
                sep = ",";
            }
            str = str + "]";
            return this.packageReadable(infoType, str);
        }
        if (info instanceof Vector) {
            str = "";
            int imax = ((Vector)info).size();
            for (int i = 0; i < imax; ++i) {
                str = str + sep + this.toReadable(null, ((Vector)info).get(i));
                sep = ",";
            }
            str = str + "\n";
            return this.packageReadable(infoType, str);
        }
        if (info instanceof Matrix3f) {
            str = "[";
            str = str + "[" + ((Matrix3f)info).m00 + "," + ((Matrix3f)info).m01 + "," + ((Matrix3f)info).m02 + "]";
            str = str + ",[" + ((Matrix3f)info).m10 + "," + ((Matrix3f)info).m11 + "," + ((Matrix3f)info).m12 + "]";
            str = str + ",[" + ((Matrix3f)info).m20 + "," + ((Matrix3f)info).m21 + "," + ((Matrix3f)info).m22 + "]";
            str = str + "]";
            return this.packageReadable(infoType, str);
        }
        if (info instanceof Point3f) {
            str = str + "[" + ((Point3f)info).x + "," + ((Point3f)info).y + "," + ((Point3f)info).z + "]";
            return this.packageReadable(infoType, str);
        }
        if (info instanceof Vector3f) {
            str = str + "[" + ((Vector3f)info).x + "," + ((Vector3f)info).y + "," + ((Vector3f)info).z + "]";
            return this.packageReadable(infoType, str);
        }
        if (info instanceof Hashtable) {
            str = "";
            Enumeration e = ((Hashtable)info).keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                str = str + sep + this.packageReadable(key, this.toReadable(null, ((Hashtable)info).get(key)));
                sep = "";
            }
            str = str + "\n";
            return this.packageReadable(infoType, str);
        }
        return this.packageReadable(infoType, info.toString());
    }
}

