% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/canvec.qplot.R
\name{canvec.qplot}
\alias{canvec.qplot}
\title{Quickly Plot Canvec Data}
\usage{
canvec.qplot(ntsid = NULL, bbox = NULL, layers = c("waterbody", "forest",
  "contour", "river", "road"), options = NULL, data = NULL,
  cachedir = NULL, plotdata = TRUE, atscale = nts.SCALE50K,
  stoponlargerequest = TRUE, epsg = NULL, ...)
}
\arguments{
\item{ntsid}{One or more NTS References as generated by \code{nts()}}

\item{bbox}{A bounding box describing the desired extent. If no \code{ntsid} is
provided, nts(bbox=bbox) will be invoked to find the appropriate NTS Reference(s)}

\item{layers}{A list of layers as defined in \code{canvec_layers$id} in the order in
which they should be plotted}

\item{options}{A list object containing the options for each layer in the form
\code{options$layerid <- list(col="lightblue")}}

\item{data}{A list object that contains the loaded Spatial* data to be plotted.
This should always be an object that was returned by \code{canvec.qplot()}}

\item{cachedir}{Pass a specific cache directory in which files have been extracted.
Default value is that returned by \code{canvec.cachedir()}}

\item{plotdata}{TRUE if data should be plotted, FALSE if data should just be loaded.}

\item{atscale}{One of \code{nts.SCALE50K} (CanVec data) or \code{nts.SCALE250K} (CanVec+ data)}

\item{stoponlargerequest}{Stop if a large (greater than 4 tiles) area is requested. Defaults to
\code{TRUE}.}

\item{epsg}{The epsg code in which to plot the data, or \code{NULL} for automatic. Use
\code{epsg=3857} to layer on Open Street Map tiles, or \code{epsg=269XX} (where \code{XX}
is the UTM Zone) for a UTM projection. Defaults to no projection, although \code{sp::plot}
adjusts the aspect such that the default does not appear distorted.}

\item{...}{A list of graphical parameters passed to the inital call to \code{plot()}. Use
\code{add=TRUE} to layer on an existing plot.}
}
\value{
A list object that contains the Spatial* data that was plotted
}
\description{
Quickly plot CanVec data with options to change the plotting style of each.
If data does not exist in the cache it will be downloaded. Simplest usage
uses \code{searchbbox()} to find an appropriate bounding box (e.g.
 \code{canvec.qplot(bbox=searchbbox("Wolfville NS"))}). Be careful plotting
 feature-intensive layers (e.g. "road", "building") over large areas (e.g.
 \code{searchbbox("toronto, on")}). This will happily run but plotting the map
 may take up to 20 minutes!
}
\examples{
\donttest{
 #simplest use using searchbbox() from {prettymapr}
 library(prettymapr)
 wolfville <- searchbbox("Wolfville NS", source="google")
 canvec.qplot(bbox=wolfville)
 canvec.qplot(bbox=wolfville, layers=c("waterbody", "forest"))

 #can also plot by NTS sheet and use bbox= or xlim, ylim to zoom.
 canvec.qplot(nts("21h1"), layers=c("waterbody", "forest", "contour", "river", "road"))
 canvec.qplot(bbox=makebbox(45.1, -64.35, 45.05, -64.4),
        layers=c("waterbody", "contour", "river", "building", "building_poly", "road"))

 #method returns plot data argument so data does not need to be loaded each time.
 #this will not work when changing nts sheets.
 plotdata <- canvec.qplot(nts("21h1"), layers=c("waterbody", "forest", "contour", "river"))
 plotdata <- canvec.qplot(bbox=makebbox(45.1, -64.35, 45.05, -64.4),
                        layers=c("waterbody", "contour", "river"),
                        data=plotdata)

 #use with prettymapr::addscalebar() and prettymapr::addnortharrow()
 library(prettymapr)
 wolfville <- searchbbox("Wolfville NS", source="google")
 canvec.qplot(bbox=wolfville)
 addscalebar()
 addnortharrow()

 #or use with prettymapr::prettymap() to set margins and add north arrow/
 #scalebar
 prettymap(canvec.qplot(bbox=wolfville))

 }
}

