% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csg_construct.R
\name{csg_combine}
\alias{csg_combine}
\title{CSG Combine}
\usage{
csg_combine(object1, object2, operation = "union", radius = 0.5)
}
\arguments{
\item{object1}{First CSG object}

\item{object2}{Second CSG object}

\item{operation}{Default `union`. Can be `union`, `subtract`, `intersection`, `blend`, `subtractblend`, or `mix`.}

\item{radius}{Default `0.5`. Blending radius.}
}
\value{
List describing the combined csg object in the scene.
}
\description{
Note: Subtract operations aren't commutative: the second object is subtracted from the first.
}
\examples{
if(run_documentation()) {
#Combine two spheres:
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
  add_object(csg_object(csg_combine(
     csg_sphere(x=-0.4,z=-0.4),
     csg_sphere(x=0.4,z=0.4), operation="union"),
  material=glossy(color="dodgerblue4"))) \%>\%
  add_object(sphere(y=5,x=5,radius=3,material=light(intensity=10))) \%>\%  
  render_scene(clamp_value=10,fov=20,lookfrom=c(-3,5,10))
  }
if(run_documentation()) {
#Subtract one sphere from another:
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
  add_object(csg_object(csg_combine(
     csg_sphere(x=-0.4,z=-0.4),
     csg_sphere(x=0.4,z=0.4), operation="subtract"),
  material=glossy(color="dodgerblue4"))) \%>\%
  add_object(sphere(y=5,x=5,radius=3,material=light(intensity=10))) \%>\%  
  render_scene(clamp_value=10,fov=20,lookfrom=c(-3,5,10))
  }
if(run_documentation()) {
#Get the intersection of two spheres:
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
  add_object(csg_object(csg_combine(
     csg_sphere(x=-0.4,z=-0.4),
     csg_sphere(x=0.4,z=0.4), operation="intersection"),
  material=glossy(color="dodgerblue4"))) \%>\%
  add_object(sphere(y=5,x=5,radius=3,material=light(intensity=10))) \%>\%  
  render_scene(clamp_value=10,fov=20,lookfrom=c(-3,5,10))
  }
if(run_documentation()) {
#Get the blended union of two spheres:
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
  add_object(csg_object(csg_combine(
     csg_sphere(x=-0.4,z=-0.4),
     csg_sphere(x=0.4,z=0.4), operation="blend"),
  material=glossy(color="dodgerblue4"))) \%>\%
  add_object(sphere(y=5,x=5,radius=3,material=light(intensity=10))) \%>\%  
  render_scene(clamp_value=10,fov=20,lookfrom=c(-3,5,10))
  }
if(run_documentation()) {
#Get the blended subtraction of two spheres:
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
  add_object(csg_object(csg_combine(
     csg_sphere(x=-0.4,z=-0.4),
     csg_sphere(x=0.4,z=0.4), operation="subtractblend"),
  material=glossy(color="dodgerblue4"))) \%>\%
  add_object(sphere(y=5,x=5,radius=3,material=light(intensity=10))) \%>\%  
  render_scene(clamp_value=10,fov=20,lookfrom=c(-3,5,10))
  }
if(run_documentation()) {
#Change the blending radius:
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
  add_object(csg_object(csg_combine(
     csg_sphere(x=-0.4,z=-0.4),
     csg_sphere(x=0.4,z=0.4), operation="blend", radius=0.2),
  material=glossy(color="dodgerblue4"))) \%>\%
  add_object(sphere(y=5,x=5,radius=3,material=light(intensity=10))) \%>\%  
  render_scene(clamp_value=10,fov=20,lookfrom=c(-3,5,10))
  }
if(run_documentation()) {
#Change the subtract blending radius:
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
  add_object(csg_object(csg_combine(
     csg_sphere(x=-0.4,z=-0.4),
     csg_sphere(x=0.4,z=0.4), operation="subtractblend", radius=0.2),
  material=glossy(color="dodgerblue4"))) \%>\%
  add_object(sphere(y=5,x=5,radius=3,material=light(intensity=10))) \%>\%  
  render_scene(clamp_value=10,fov=20,lookfrom=c(-3,5,10))
  }
if(run_documentation()) {
#Get the mixture of various objects:
generate_ground(material=diffuse(checkercolor="grey20")) \%>\% 
  add_object(csg_object(csg_combine(
     csg_sphere(),
     csg_box(), operation="mix"),
  material=glossy(color="dodgerblue4"))) \%>\%
  add_object(csg_object(csg_translate(csg_combine(
     csg_box(),
     csg_torus(), operation="mix"),z=-2.5),
  material=glossy(color="red"))) \%>\%
  add_object(csg_object(csg_translate(csg_combine(
     csg_pyramid(),
     csg_box(), operation="mix"),z=2.5),
  material=glossy(color="green"))) \%>\%
  add_object(sphere(y=10,x=-5,radius=3,material=light(intensity=10))) \%>\%  
  render_scene(clamp_value=10,fov=20,lookfrom=c(-15,10,10))
}
}
