% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter-decimate.R
\name{decimate}
\alias{decimate}
\title{Decimate with 'FIR' or 'IIR' filter}
\usage{
decimate(x, q, n = if (ftype == "iir") 8 else 30, ftype = "fir")
}
\arguments{
\item{x}{signal to be decimated}

\item{q}{integer factor to down-sample by}

\item{n}{filter order used in the down-sampling; default is \code{30}
if \code{ftype='fir'}, or \code{8} if \code{ftype='iir'}}

\item{ftype}{filter type, choices are \code{'fir'} (default) and
\code{'iir'}}
}
\value{
Decimated signal
}
\description{
Decimate with 'FIR' or 'IIR' filter
}
\details{
This function is migrated from \code{gsignal} package,
but with padding and indexing fixed. The results agree with 'Matlab'.
}
\examples{

x <- 1:100
y <- decimate(x, 2, ftype = "fir")
y

# compare with signal package
z <- gsignal::decimate(x, 2, ftype = "fir")

# Compare decimated results
plot(x, type = 'l')
points(seq(1,100, 2), y, col = "green")
points(seq(1,100, 2), z, col = "red")


}
