% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{filter_signal}
\alias{filter_signal}
\title{Filter one-dimensional signal}
\usage{
filter_signal(b, a, x, z)
}
\arguments{
\item{b}{one-dimensional real numerical vector, the moving-average
coefficients of an \code{ARMA} filter}

\item{a}{the auto-regressive (recursive) coefficients of an \code{ARMA} filter}

\item{x}{numerical vector input (real value)}

\item{z}{initial condition, must have length of \code{n-1}, where \code{n}
is the maximum of lengths of \code{a} and \code{b}; default is all zeros}
}
\value{
A list of two vectors: the first vector is the filtered signal;
the second vector is the final state of \code{z}
}
\description{
The function is written from the scratch. The result has been
compared against the 'Matlab' \code{filter} function with one-dimensional
real inputs. Other situations such as matrix \code{b} or multi-dimensional
\code{x} are not implemented.
}
\examples{


t <- seq(0, 1, by = 0.01)
x <- sin(2 * pi * t * 2.3)
bf <- signal::butter(2, c(0.15, 0.3))

res <- filter_signal(bf$b, bf$a, x)
y <- res[[1]]
z <- res[[2]]

## Matlab (2022a) equivalent:
# t = [0:0.01:1];
# x = sin(2 * pi * t * 2.3);
# [b,a] = butter(2,[.15,.3]);
# [y,z] = filter(b, a, x)


}
