% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline-knitr.R
\name{pipeline-knitr-markdown}
\alias{pipeline-knitr-markdown}
\alias{configure_knitr}
\alias{pipeline_setup_rmd}
\title{Configure \code{'rmarkdown'} files to build 'RAVE' pipelines}
\usage{
configure_knitr(languages = c("R", "python"))

pipeline_setup_rmd(
  module_id,
  env = parent.frame(),
  collapse = TRUE,
  comment = "#>",
  languages = c("R", "python"),
  project_path = dipsaus::rs_active_project(child_ok = TRUE, shiny_ok = TRUE)
)
}
\arguments{
\item{languages}{one or more programming languages to support; options are
\code{'R'} and \code{'python'}}

\item{module_id}{the module ID, usually the name of direct parent folder
containing the pipeline file}

\item{env}{environment to set up the pipeline translator}

\item{collapse, comment}{passed to \code{set} method of
\code{\link[knitr]{opts_chunk}}}

\item{project_path}{the project path containing all the pipeline folders,
usually the active project folder}
}
\value{
A function that is supposed to be called later that builds the
pipeline scripts
}
\description{
Allows building 'RAVE' pipelines from \code{'rmarkdown'} files.
Please use it in \code{'rmarkdown'} scripts only. Use
\code{\link{pipeline_create_template}} to create an example.
}
