% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rave-prepare-subjectbare.R,
%   R/rave-prepare-subjectblock.R, R/rave-prepare-voltage-with-epoch.R,
%   R/rave-prepare.R
\name{prepare_subject_bare0}
\alias{prepare_subject_bare0}
\alias{prepare_subject_bare}
\alias{prepare_subject_with_epoch}
\alias{prepare_subject_power}
\alias{prepare_subject_with_blocks}
\alias{prepare_subject_raw_voltage_with_epoch}
\alias{prepare_subject_voltage_with_epoch}
\alias{rave-prepare}
\title{Prepare 'RAVE' single-subject data}
\usage{
prepare_subject_bare0(
  subject,
  electrodes,
  reference_name,
  ...,
  quiet = TRUE,
  repository_id = NULL
)

prepare_subject_bare(
  subject,
  electrodes,
  reference_name,
  ...,
  repository_id = NULL
)

prepare_subject_with_epoch(
  subject,
  electrodes,
  reference_name,
  epoch_name,
  time_windows,
  env = parent.frame(),
  ...
)

prepare_subject_power(
  subject,
  electrodes,
  reference_name,
  epoch_name,
  time_windows,
  signal_type = c("LFP"),
  env = parent.frame(),
  verbose = TRUE,
  ...
)

prepare_subject_with_blocks(
  subject,
  electrodes,
  reference_name,
  blocks,
  signal_type = "LFP",
  time_frequency = signal_type == "LFP",
  env = parent.frame(),
  repository_id = NULL,
  ...
)

prepare_subject_raw_voltage_with_epoch(
  subject,
  electrodes,
  epoch_name,
  time_windows,
  ...,
  quiet = TRUE,
  repository_id = NULL
)

prepare_subject_voltage_with_epoch(
  subject,
  electrodes,
  epoch_name,
  time_windows,
  reference_name,
  ...,
  quiet = TRUE,
  repository_id = NULL
)
}
\arguments{
\item{subject}{character of project and subject, such as \code{"demo/YAB"},
or \code{\link{RAVESubject}} instance}

\item{electrodes}{integer vector of electrodes, or a character that can be
parsed by \code{\link[dipsaus]{parse_svec}}}

\item{reference_name}{reference name to be loaded}

\item{...}{ignored}

\item{quiet}{whether to quietly load the data}

\item{repository_id}{used internally}

\item{epoch_name}{epoch name to be loaded, or a
\code{\link{RAVEEpoch}} instance}

\item{time_windows}{a list of time windows that are relative to epoch onset
time; need to pass the validation \code{\link{validate_time_window}}}

\item{env}{environment to evaluate}

\item{signal_type}{electrode signal type (length of one) to be considered;
default is 'LFP'. This option rarely needs to change unless you really want
to check the power data from other types. For other signal types, check
\code{\link{SIGNAL_TYPES}}}

\item{verbose}{whether to show progress}

\item{blocks}{one or more session blocks to load}

\item{time_frequency}{whether to load time-frequency data when preparing
block data}
}
\value{
A \code{\link[dipsaus]{fastmap2}} (basically a list) of objects.
Depending on the functions called, the following items may exist in the list:
\describe{
\item{\code{subject}}{A \code{\link{RAVESubject}} instance}
\item{\code{epoch_name}}{Same as input \code{epoch_name}}
\item{\code{epoch}}{A \code{\link{RAVEEpoch}} instance}
\item{\code{reference_name}}{Same as input \code{reference_name}}
\item{\code{reference_table}}{A data frame of reference}
\item{\code{electrode_table}}{A data frame of electrode information}
\item{\code{frequency}}{A vector of frequencies}
\item{\code{time_points}}{A vector of time-points}
\item{\code{power_list}}{A list of power data of the electrodes}
\item{\code{power_dimnames}}{A list of trial indices, frequencies, time
points, and electrodes that are loaded}
}
}
\description{
Prepare 'RAVE' single-subject data
}
