% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-rave-compcontainer.R
\name{new_rave_shiny_component_container}
\alias{new_rave_shiny_component_container}
\title{Creates a container for preset components}
\usage{
new_rave_shiny_component_container(
  module_id,
  pipeline_name,
  pipeline_path = raveio::pipeline_find(pipeline_name),
  settings_file = "settings.yaml"
)
}
\arguments{
\item{module_id}{'RAVE' module ID}

\item{pipeline_name}{the name of pipeline to run}

\item{pipeline_path}{path of the pipeline}

\item{settings_file}{the settings file of the pipeline, usually stores the
pipeline input information; default is \code{"settings.yaml"}}
}
\value{
A \code{'RAVEShinyComponentContainer'} instance
}
\description{
Creates a container for preset components
}
\examples{


f <- tempfile()
dir.create(f, showWarnings = FALSE, recursive = TRUE)
file.create(file.path(f, "settings.yaml"))

container <- new_rave_shiny_component_container(
  module_id = "module_power_phase_coherence",
  pipeline_name = "power_phase_coherence_pipeline",
  pipeline_path = f
)

loader_project <- presets_loader_project()
loader_subject <- presets_loader_subject()

container$add_components(
  loader_project, loader_subject
)


}
