#' Data and phylogenetic tree for Centrarchidae fishes
#'
#' Data from Revell and Collar (2009). Measurements are log-transformed and size-corrected.
#'
#' @docType data
#'
#' @usage data(centrarchidae)
#'
#' @format A list with a dataframe with the morphological data ($data) and a 'Simmap' format tree with the regime of "narrow_diet" and "wide_diet" mapped on the tree ($phy.map).
#'
#' @keywords datasets
#'
#' @references Revell, L. J., and D. C. Collar. 2009. Phylogenetic Analysis of the Evolutionary Correlation Using Likelihood. Evolution 63:1090–1100.
#' @references Revell, L. J. 2013. Ancestral character estimation under the threshold model from quantitative genetics. Evolution 68(3):743–759.
#'
#' @source http://datadryad.org/resource/doi:10.5061/dryad.4t157/1
"centrarchidae"
