% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastSimmap.R
\name{fastSimmap}
\alias{fastSimmap}
\title{Fast implementation of stochastic mapping.}
\usage{
fastSimmap(
  tree,
  x,
  Q,
  pi = "equal",
  nsim = 1,
  mc.cores = 1,
  max_nshifts = 100,
  silence = FALSE
)
}
\arguments{
\item{tree}{a phylogenetic tree of class 'phylo'.}

\item{x}{a named vector with the states observed at the tips of the tree.}

\item{Q}{a Markov transition matrix for the Markov Model. This needs to be provided and the user can estimate such matrix from the observed data using any of a multitude of methods.}

\item{pi}{one of 'equal' or 'madfitz'.}

\item{nsim}{number of stochastic mappings to be performed conditioned on Q. NOT IMPLEMENTED YET!}

\item{mc.cores}{same as in 'parallel::mclapply'. This is used to make multiple simulations (controlled with the argument 'nsim') by calling 'parallel::mclapply'.}

\item{max_nshifts}{allocate the max number of events in any given branch. See 'Details'.}

\item{silence}{if function should stop printing messages. This will also stop checks for data format and some informative errors.}
}
\value{
A stochastic mapped phylogeny of class 'simmap'.
}
\description{
Make stochastic map simulations conditioned on a Markov matrix 'Q' and a vector of root probabilities 'pi'.
}
\details{
This function is a simplification of Revell's 'phytools::make.simmap' function. Here the stochastic mapping is performed conditioned on a given Markov matrix and a vector of probabilities for the root node. This allows users to fit the Mk model using any preferred method and use this function to perform the stochastic mapping on the tree.

The prior probabilities at the root can be set to "equal" (i.e., all states have the same probability to be observed at the root) or to "madfitz" (i.e., state probabilities follow the likelihood of the Mk model).

The argument 'max_nshifts' controls the max number of state changes in any given branch of the phylogeny. This sets the size of the "buffer" that records the events that happen on the branches. It has no influence in the model, it is only a contraint of the fast implementation of the stochastic mapping algorithm. Set this value to a high enough number (i.e., more changes that can possibly happen at any given branch).

The reduced time is accomplished by using compiled code to perfom simulations ( C++ ). All calculations are the same as Revell's original function.
}
\author{
Daniel Caetano
}
