% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rplot.R
\name{rplot}
\alias{rplot}
\alias{rplot.default}
\title{Rasterly plot}
\usage{
rplot(x, y = NULL, ...)

\method{rplot}{default}(
  x,
  y = NULL,
  ...,
  plot_width = 600,
  plot_height = 600,
  x_range = NULL,
  y_range = NULL,
  background = "white",
  reduction_func = NULL,
  layout = NULL,
  glyph = NULL
)
}
\arguments{
\item{x, y}{Coordinates x, y for the plot.}

\item{...}{Other \code{rasterly} arguments to pass through.}

\item{plot_width}{Integer. The width of the image to plot; must be a positive integer. A higher value indicates a higher resolution.}

\item{plot_height}{Integer. The height of the image to plot; must be a positive integer. A higher value indicates a higher resolution.}

\item{x_range}{Vector of type numeric. The range of \code{x}; it can be used to clip the image. For larger datasets, providing \code{x_range}
may result in improved performance.}

\item{y_range}{Vector of type numeric. The range of \code{y}; it can be used to clip the image. For larger datasets, providing \code{y_range}
may result in improved performance.}

\item{background}{Character. The background color of the image to plot.}

\item{reduction_func}{Function. A reduction function is used to aggregate data points into their pixel representations. Currently
supported reduction operators are \code{sum}, \code{any}, \code{mean}, \code{m2}, \code{first}, \code{last}, \code{min} and \code{max}. Default is \code{sum}. See details.}

\item{layout}{Character. The method used to generate layouts for multiple images. The default is \code{weighted}. Useful for categorical
data (i.e. "color" is provided via \code{aes()}). \code{weighted} specifies that the final raster should be a weighted combination of each
(categorical) aggregation matrix. Conversely, \code{cover} indicates that the afterwards objects will be drawn on top of 
the previous ones.}

\item{glyph}{Character. Currently, only "circle" and "square" are supported; as the \code{size} of the pixels increases, how should they
spread out -- should the pattern be circular or square? Other glyphs may be added in the future.}
}
\description{
\code{rplot} is created to generate \code{rasterly} plot quickly but with base 
\link{plot} design. It is convenient but lacks flexibility and \link{rasterly} is highly
recommended for a more versatile method.
}
\details{
\code{rasterly} arguments are passed through via \code{...}. But some of them are noticeable.
\itemize{
 \item{\code{size}: Size can be either a specified size (1, 2, 3, etc) or a mapping variable. Since \code{rasterly} does not provide
 point to point display, if the length of input \code{size} is the same with the length of \code{x} (or \code{y}). It will be treated as 
 a mapping variable.}
 \item{\code{color}: Color can be either a color map vector or a mapping variable. If the length of \code{color} is equal to the length of 
 \code{x} (or \code{y}). It will be treated as a mapping variable.}
 \item{\code{on}: On is always treated as a mapping variable.}
}
}
\examples{
if(requireNamespace("ggplot2")) {
  library(ggplot2)
  # `color` represents a variable here
  with(diamonds, 
       rplot(x = carat, y = price, color = color)
  )
  # `color` represents an actual color vector
  with(diamonds, 
       rplot(x = carat, y = price, color = fire_map)
  )
}
}
\seealso{
\link{rasterly} \link{rasterly_points}
}
