% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterImage.r
\name{rasterImage2}
\alias{rasterImage2}
\title{Plotting a raster image with axis and color legend}
\usage{
rasterImage2(x = NULL, y = NULL, z, zlim = NULL, xlim = NULL,
  ylim = NULL, dim.max = NULL, plot.zero.line = T, regularGrid = T,
  zlab = NULL, z.cex = 0.5, z.adj = c(0.5, 0.5), z.format = "fg",
  ndz = 7, ncolors = 256, palette = "spectral", palette.inv = F, ...)
}
\arguments{
\item{x}{x-axis vector corresponding to the z-matrix}

\item{y}{y-axis vector corresponding to the z-matrix}

\item{z}{numeric matrix to be plotted}

\item{zlim}{sets the range of the color coded z-axis}

\item{xlim}{the x limits (x1, x2) of the plot.  Note that \code{x1 > x2}
    is allowed and leads to a \sQuote{reversed axis}.

    The default value, \code{NULL}, indicates that the range of the
    \link{finite} values to be plotted should be used.}

\item{ylim}{the y limits of the plot.}

\item{dim.max}{defines the dimensions of z, if it needs to be rescaled.
This parameter can improve plotting speed.}

\item{plot.zero.line}{logical, if a line at \code{x = 0} and \code{y = 0} is
to be plotted.}

\item{regularGrid}{logical, if \code{FALSE} then a vector plot is generated,
which is the slow and standard behaviour of \code{image}.
If this parameter is \code{TRUE} then a raster image is
generated, which can be processed much faster, compared to
the \code{FALSE} option.}

\item{zlab}{defines the z-label}

\item{z.cex}{cex value for the z-label. It sets the font size in relation to
the global \code{par()$cex} value}

\item{z.adj}{a two component vector. It sets the left/right and top/bottom
justification}

\item{z.format}{controls how the numbers besides the colorscale are comosed.
It works like the \code{format} option of \code{\link{formatC}}}

\item{ndz}{sets the axis breakes right to the colorscale}

\item{ncolors}{number of colors to use in the plot}

\item{palette}{defines the color palette to be used in the plot}

\item{palette.inv}{logical, if \code{TRUE} reverts the color palette}

\item{...}{further arguments to the plot function, e.g. \code{'xlab'}}
}
\description{
The function is a wrapper for the \code{image()} function, but with a comfortable
comtrol of the z-axis and its color legend. The wrapper also supports image
resizing (resolution) and png output for better export.
}
\examples{
 rasterImage2( z = volcano, palette = "spectral", dim.max = c(500,500)
             ,zlab = "Height", z.adj = c(0,1) ,z.cex = 1
             ,main = "Volcano Data Set"
           )
}

