% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/figure.r
\name{figure}
\alias{figure}
\title{Reproduce Figures from Fuentes et al. (n.d.)}
\usage{
figure(x, d, scaling = 100, to.disk = FALSE, verbose = FALSE)
}
\arguments{
\item{x}{Integer. Number identifying the figure to reproduce.}

\item{d}{List. List with the data required for the figure to reproduce.}

\item{scaling}{Integer. This number scales (i.e., resizes) the R's plotting
device, such that \emph{width = x/scaling & height = x/scaling},
with \emph{x} = pixels. The default pixel size (not adjustable) and scaling
value should work fine. Default = 100}

\item{to.disk}{Boolean. Save figure to disk? Default = FALSE}

\item{verbose}{Boolean. Show warning messages in the console? Default: FALSE}
}
\value{
None
}
\description{
This function is intended to reproduce the figures presented in \emph{rassta:
Raster-based Spatial Stratification Algorithms} (Fuentes et al., 2021). Note
that this function assumes that all the necessary inputs for each figure are
loaded in the working environment. For the creation of each input, please
refer to the data and examples presented in the aforementioned work. Also,
please note that the use of this function is not intended for RStudio.
}
\examples{
if(interactive()){
require(terra)
p <- system.file("exdat", package = "rassta")
# Single-layer SpatRaster of geologic units
f <- list.files(path = p, pattern = "geology.tif", full.names = TRUE)
geol <- terra::rast(f)
# Dummy layers from geologic units
mat.sig <- dummies(ca.rast = geol, preval = 100, absval = 0)
figure(17, d = mat.sig)
}

}
\references{
B.A. Fuentes, M.J. Dorantes, and J.R. Tipton. rassta: Raster-based Spatial
Stratification Algorithms. EarthArXiv, 2021.
\doi{https://doi.org/10.31223/X50S57}
}
\seealso{
Other Miscellaneous Functions: 
\code{\link{dummies}()},
\code{\link{plot3D}()}
}
\concept{Miscellaneous Functions}
