% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dummies.r
\name{dummies}
\alias{dummies}
\title{Create Dummy Layers from Categorical Raster Layers}
\usage{
dummies(
  ca.rast,
  vals = NULL,
  preval = 100,
  absval = 0,
  to.disk = FALSE,
  outdir = ".",
  extension = ".tif",
  ...
)
}
\arguments{
\item{ca.rast}{SpatRaster, as in \code{\link[terra]{rast}}. Single-layer
SpatRaster whose (integer) cell values represent numeric IDs for
categories.}

\item{vals}{Integer. Vector or sequence of values representing the categories
for which dummy layers will be created. If NULL, all categories will be
processed. Default: NULL}

\item{preval}{Integer. Value indicating presence of category. Default: 100}

\item{absval}{Integer. Value indicating absence of category. Default: 0}

\item{to.disk}{Boolean. Write output dummy layers to disk? Default: FALSE}

\item{outdir}{Character. If \emph{to.disk = TRUE}, string specifying the path
for the output dummy raster layers. Default: "."}

\item{extension}{Character. If \emph{to.disk = TRUE}, String specifying the
extension for the output raster layers (see \strong{Details}). Default:
".tif"}

\item{...}{If \emph{to.disk = TRUE}, additional arguments as for
\code{\link[terra]{writeRaster}}.}
}
\value{
Single-layer or multi-layer SpatRaster with dummy layer(s).
}
\description{
Given a SpatRaster whose cell values represent categories (e.g., soil types,
land use/cover classes), a dummy layer indicating the presence/absence of
each category is created, and optionally written on disk. Each category in
the raster layer must be represented by a unique integer cell value. Output
values indicating the presence or absence of categories in the dummy layers
may be set using \emph{preval} and \emph{absval} arguments, respectively.
}
\details{
This function mainly differs from \code{\link[terra]{segregate}} in
that presence and absence values can be set arbitrarily, thus allowing for
values other than those traditionally used in one-hot/dummy encoding (i.e.,
1 and 0).

Please note that the argument \emph{extension} does not correspond to the
argument \emph{filetype} in \code{\link[terra]{writeRaster}}. However,
\code{\link[terra]{writeRaster}} should recognize the appropriate extension
for the output raster layers from the \emph{extension} argument. For
instance, by setting \emph{extension = ".tif"},
\code{\link[terra]{writeRaster}} will recognize the extension as
\emph{GeoTiff}, which is the GDAL driver name.
}
\examples{
require(terra)
p <- system.file("exdat", package = "rassta")
# Single-layer SpatRaster of geologic units
f <- list.files(path = p, pattern = "geology2.tif", full.names = TRUE)
geol <- terra::rast(f)
# Dummy layer from geologic unit 1
dums <- dummies(ca.rast = geol, vals = 1, preval = 100, absval = 0)

}
\seealso{
\code{\link[terra]{segregate}}

Other Miscellaneous Functions: 
\code{\link{figure}()},
\code{\link{plot3D}()}
}
\concept{Miscellaneous Functions}
