% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/RapData.R, R/RapSolved.R
\name{dp.subset}
\alias{dp.subset}
\alias{dp.subset.RapData}
\alias{dp.subset.RapUnsolOrSol}
\title{Subset demand points}
\usage{
dp.subset(x, space, species, points)

\method{dp.subset}{RapData}(x, space, species, points)

\method{dp.subset}{RapUnsolOrSol}(x, space, species, points)
}
\arguments{
\item{x}{\code{\link[=RapData]{RapData()}}, \code{\link[=RapUnsolved]{RapUnsolved()}}, or
\code{\link[=RapSolved]{RapSolved()}} object.}

\item{space}{\code{integer} vector to specify the index of the space to
subset demand points from.}

\item{species}{\code{integer} vector to specify the index of the species to
subset demand points from.}

\item{points}{\code{integer} vector to specify the index of demand points to
subset.}
}
\value{
\code{\link[=RapData]{RapData()}} or \code{\link[=RapUnsolved]{RapUnsolved()}} object depending
on input object.
}
\description{
Subset demand points from a \code{\link[=RapData]{RapData()}},
\code{\link[=RapUnsolved]{RapUnsolved()}}, or \code{\link[=RapSolved]{RapSolved()}} object.
}
\examples{
\dontrun{
# load data
data(sim_ru)

# generate new object with first 10 planning units
sim_ru2 <- dp.subset(sim_ru, 1, 1, seq_len(10))
}
}
\seealso{
\code{\link[=RapData]{RapData()}}, \code{\link[=RapUnsolved]{RapUnsolved()}},
\code{\link[=RapSolved]{RapSolved()}}.
}
