% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/RapData.R, R/RapSolved.R
\name{amount.target}
\alias{amount.target}
\alias{amount.target<-}
\alias{amount.target.RapData}
\alias{amount.target<-.RapData}
\alias{amount.target.RapUnsolOrSol}
\alias{amount.target<-.RapUnsolOrSol}
\title{Amount targets}
\usage{
amount.target(x, species)

amount.target(x, species) <- value

\method{amount.target}{RapData}(x, species = NULL)

\method{amount.target}{RapData}(x, species = NULL) <- value

\method{amount.target}{RapUnsolOrSol}(x, species = NULL)

\method{amount.target}{RapUnsolOrSol}(x, species = NULL) <- value
}
\arguments{
\item{x}{\code{\link{RapData}}, \code{\link{RapUnsolved}}, or
\code{\link{RapSolved}} object.}

\item{species}{\code{NULL} for all species or \code{integer} indicating
species.}

\item{value}{\code{numeric} new target.}
}
\value{
code{numeric} vector.
}
\description{
This function sets or returns the target amounts for each species.
}
\examples{
# load data
data(sim_rs)

# extract amount targets for all species
amount.target(sim_rs)

# set amount targets for all species
amount.target(sim_rs) <- 0.1

# extract amount targets for first species
amount.target(sim_rs, 1)

# set amount targets for for first species
amount.target(sim_rs, 1) <- 0.5

}
\seealso{
\code{\link{RapData}}, \code{\link{RapResults}},
  \code{\link{RapSolved}}.
}
