% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{rasterizeGDAL}
\alias{rasterizeGDAL}
\title{Rasterize polygon data using GDAL}
\usage{
rasterizeGDAL(x, y, field = NULL)
}
\arguments{
\item{x}{\code{SpatialPolygonsDataFrame} object.}

\item{y}{\code{RasterLayer} with dimensions, extent, and resolution to be used as a template for new raster.}

\item{field}{\code{character} column name with values to burn into the output raster. If not supplied, default behaviour is to burn polygon indices into the \code{    RasterLayer}.}
}
\value{
\code{RasterLayer} object.
}
\description{
This function converts a \code{SpatialPolygonsDataFrame} to a \code{RasterLayer} using GDAL.
It is expected to be faster than \code{\link[raster]{rasterize}} for large datasets.
However, it will be significantly slower for small datasets because the data will need to be written and read from disk.
}
\examples{
\dontrun{
data(sim_pu,sim_spp)
x <- rasterizeGDAL(sim_pu[1:5,],sim_spp[[1]])
}
}
\seealso{
\code{\link[raster]{rasterize}}, \code{\link{is.gdalInstalled}}.
}

