% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MapProcess-methods.R
\docType{methods}
\name{processRanges}
\alias{processRanges}
\alias{processRanges,SQLiteConnection,SpatialPolygonsDataFrame,missing,character,missing-method}
\alias{processRanges,SQLiteConnection,SpatialPolygonsDataFrame,missing,character,list-method}
\alias{processRanges,SQLiteConnection,missing,character,missing,missing-method}
\alias{processRanges,SQLiteConnection,missing,character,missing,list-method}
\title{processRanges}
\usage{
processRanges(con, spdf, dir, ID, metadata, parallel)


  \S4method{processRanges}{SQLiteConnection,SpatialPolygonsDataFrame,missing,character,missing}(con,
  spdf, ID, metadata, parallel)


  \S4method{processRanges}{SQLiteConnection,SpatialPolygonsDataFrame,missing,character,list}(con,
  spdf, ID, metadata, parallel)


  \S4method{processRanges}{SQLiteConnection,missing,character,missing,missing}(con,
  dir, parallel)


  \S4method{processRanges}{SQLiteConnection,missing,character,missing,list}(con,
  dir, metadata, parallel)
}
\arguments{
\item{con}{a \code{connection} object.}

\item{spdf}{\code{\link[sp]{SpatialPolygonsDataFrame}} object containing all the ranges.}

\item{dir}{ranges file directory where the individual ranges shp files are located. In this case the range ID is the file name.}

\item{ID}{a character vector of length one. An \code{spdf} column name indicating the range ID (e.g. species name).}

\item{metadata}{a named list of functions. See \code{\link{rangeTraits}} and \code{\link{metadata.update}}.}

\item{parallel}{default to FALSE. When TRUE a \code{multiprocess} evaluation scheme is initiated.}
}
\description{
processRanges
}
\section{Methods (by class)}{
\itemize{
\item \code{con = SQLiteConnection,spdf = SpatialPolygonsDataFrame,dir = missing,ID = character,metadata = missing}: Method 1: One SpatialPolygonsDataFrame containing all the ranges. No metadata.

\item \code{con = SQLiteConnection,spdf = SpatialPolygonsDataFrame,dir = missing,ID = character,metadata = list}: Method 2: One SpatialPolygonsDataFrame containing all the ranges. Metadata are computed.

\item \code{con = SQLiteConnection,spdf = missing,dir = character,ID = missing,metadata = missing}: Method 3: Each range file is a separate shp file. No metadata.

\item \code{con = SQLiteConnection,spdf = missing,dir = character,ID = missing,metadata = list}: Method 4: Each range file is a separate shp file. Metadata are computed.
}}

\examples{
require(rangeMapper)
require(rgdal)

dbcon = rangeMap.start(file = "wrens.sqlite", dir = tempdir(), overwrite = TRUE)
f = system.file(package = "rangeMapper", "extdata", "wrens", "vector_combined")
r = readOGR(f, "wrens", verbose = FALSE)[1:50, ]
global.bbox.save(con = dbcon, bbox = r)
gridSize.save(dbcon, gridSize = 5)
canvas.save(dbcon)
processRanges(con = dbcon, spdf = r, ID = "sci_name", metadata = rangeTraits() )
dbDisconnect(dbcon)

}
