% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/createParam.R
\name{createParam}
\alias{createParam}
\title{Representing any randomization procedure}
\usage{
createParam(method, N, mti, bc, rb, p, ini, add)
}
\arguments{
\item{method}{method that is used to generate the (random) allocation
sequence. It can take values \code{PBR}, \code{RAR}, \code{HAD}, \code{PWR},
\code{EBC}, \code{BSD}, \code{CR}, \code{TBD}, \code{UD}, and \code{MP}.}

\item{N}{integer for the total sample size of the trial.}

\item{mti}{maximum tolerated imbalance in patient numbers during the trial.}

\item{bc}{vector which contains the lengths \code{k_1,...,k_l} of each block.
This means that the vector \code{bc} will have one entry for each block.}

\item{rb}{block lengths of the blocks that can be selected equiprobable at random.}

\item{p}{success probability of the biased coin (e.g. in Efron's Biased Coin
Design).}

\item{ini}{integer representing the initial urn composition.}

\item{add}{integer representing the number of balls that are added to the
urn in each step.}
}
\value{
S4object of the corresponding randomization procedure class.
}
\description{
Represents any randomization procedure for a two-armed clinical trial.
}
\details{
Dending on the input of the user, \code{createParam} creates an object
representing a randomization procedures for a two-armed clinical trial
(see also \code{\link{randPar}}).
}
\seealso{
Other randomization procedures: \code{\link{bsdPar}};
  \code{\link{crPar}}; \code{\link{ebcPar}};
  \code{\link{hadaPar}}; \code{\link{mpPar}};
  \code{\link{pbrPar}}; \code{\link{rarPar}};
  \code{\link{rpbrPar}}; \code{\link{rtbdPar}};
  \code{\link{tbdPar}}; \code{\link{udPar}}
}

