#' @name raincpc
#' 
#' @title Obtain and analyze global rainfall data from the Climate Prediction 
#' Center.
#'
#' @details The Climate Prediction Center's (CPC) global rainfall data, 1979 to 
#' present, 0.5 degree resolution (or 50 km), is one of the few high quality, 
#' long term, observation based, daily rainfall products available for free. 
#' Although raw data is available at CPC's ftp site, obtaining, processing and 
#' visualizing the data is not straightforward - there are more than 12000 files 
#' and file formats and file extensions have changed over time. \pkg{raincpc} 
#' provides functionality to download, process and visualize over 35 years of 
#' global daily rainfall data from CPC.
#'
#' @import SDMTools
#' 
#' @docType package
#' 
#' @author Gopi Goteti
#' 
#' @references Climate Prediction Center's (CPC), \url{www.cpc.ncep.noaa.gov}, 
#' global rainfall data, 1979 to present, daily time step, 0.5 degree (or 50 km) 
#' resolution, ftp site \url{ftp.cpc.ncep.noaa.gov/precip/CPC_UNI_PRCP/GAUGE_GLB/}
NULL
